/*
 * Decompiled with CFR 0.152.
 */
package net.lionarius.skinrestorer.config.provider.collection;

import java.net.URI;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import net.lionarius.skinrestorer.SkinRestorer;
import net.lionarius.skinrestorer.config.provider.collection.CollectionSkinSource;
import net.lionarius.skinrestorer.skin.SkinVariant;
import net.lionarius.skinrestorer.util.gson.GsonPostProcessable;
import org.jetbrains.annotations.Nullable;

public final class CollectionSkinFile
implements CollectionSkinSource,
GsonPostProcessable {
    private String path = "";
    private SkinVariant variant = SkinVariant.CLASSIC;

    @Override
    @Nullable
    public URI uri() {
        if (this.path.isEmpty()) {
            return null;
        }
        try {
            Path filePath = SkinRestorer.getConfigDir().resolve(this.path);
            if (!Files.exists(filePath, new LinkOption[0])) {
                SkinRestorer.LOGGER.warn("Skin file does not exist: {}", (Object)this.path);
                return null;
            }
            if (!Files.isRegularFile(filePath, new LinkOption[0])) {
                SkinRestorer.LOGGER.warn("Skin path is not a file: {}", (Object)this.path);
                return null;
            }
            if (!this.path.toLowerCase().endsWith(".png")) {
                SkinRestorer.LOGGER.warn("Skin file is not a PNG file: {}", (Object)this.path);
                return null;
            }
            return filePath.toUri();
        }
        catch (Exception e) {
            SkinRestorer.LOGGER.warn("Invalid file path: {}", (Object)this.path, (Object)e);
            return null;
        }
    }

    @Override
    public SkinVariant variant() {
        return this.variant;
    }

    @Override
    public void gsonPostProcess() {
        if (this.path == null) {
            this.path = "";
        }
        if (this.variant == null) {
            this.variant = SkinVariant.CLASSIC;
        }
    }
}

