/*
 * Decompiled with CFR 0.152.
 */
package top.mcmtr.mod.packet;

import org.mtr.libraries.it.unimi.dsi.fastutil.longs.LongAVLTreeSet;
import org.mtr.mapping.holder.BlockEntity;
import org.mtr.mapping.holder.BlockPos;
import org.mtr.mapping.holder.MinecraftServer;
import org.mtr.mapping.holder.ServerPlayerEntity;
import org.mtr.mapping.registry.PacketHandler;
import org.mtr.mapping.tool.PacketBufferReceiver;
import org.mtr.mapping.tool.PacketBufferSender;
import top.mcmtr.mod.blocks.BlockYamanoteRailwaySign;

public final class MSDPacketUpdateYamanoteRailwaySignConfig
extends PacketHandler {
    private final BlockPos blockPos;
    private final LongAVLTreeSet selectedIds;
    private final String[] signIds;

    public MSDPacketUpdateYamanoteRailwaySignConfig(PacketBufferReceiver packetBufferReceiver) {
        this.blockPos = BlockPos.fromLong((long)packetBufferReceiver.readLong());
        int selectedIdsLength = packetBufferReceiver.readInt();
        this.selectedIds = new LongAVLTreeSet();
        for (int i = 0; i < selectedIdsLength; ++i) {
            this.selectedIds.add(packetBufferReceiver.readLong());
        }
        int signLength = packetBufferReceiver.readInt();
        this.signIds = new String[signLength];
        for (int i = 0; i < signLength; ++i) {
            String signId = packetBufferReceiver.readString();
            this.signIds[i] = signId.isEmpty() ? null : signId;
        }
    }

    public MSDPacketUpdateYamanoteRailwaySignConfig(BlockPos blockPos, LongAVLTreeSet selectedIds, String[] signIds) {
        this.blockPos = blockPos;
        this.selectedIds = selectedIds;
        this.signIds = signIds;
    }

    public void write(PacketBufferSender packetBufferSender) {
        packetBufferSender.writeLong(this.blockPos.asLong());
        packetBufferSender.writeInt(this.selectedIds.size());
        this.selectedIds.forEach(arg_0 -> ((PacketBufferSender)packetBufferSender).writeLong(arg_0));
        packetBufferSender.writeInt(this.signIds.length);
        for (String signId : this.signIds) {
            packetBufferSender.writeString(signId == null ? "" : signId);
        }
    }

    public void runServer(MinecraftServer minecraftServer, ServerPlayerEntity serverPlayerEntity) {
        BlockEntity entity = serverPlayerEntity.getEntityWorld().getBlockEntity(this.blockPos);
        if (entity != null && entity.data instanceof BlockYamanoteRailwaySign.BlockYamanoteRailwaySignEntity) {
            ((BlockYamanoteRailwaySign.BlockYamanoteRailwaySignEntity)((Object)entity.data)).setData(this.selectedIds, this.signIds);
        }
    }
}

