/*
 * Decompiled with CFR 0.152.
 */
package top.mcmtr.mod.blocks;

import org.mtr.mapping.holder.BlockEntityType;
import org.mtr.mapping.holder.BlockPos;
import org.mtr.mapping.holder.BlockState;
import org.mtr.mapping.holder.BlockView;
import org.mtr.mapping.holder.Direction;
import org.mtr.mapping.holder.DirectionProperty;
import org.mtr.mapping.holder.ShapeContext;
import org.mtr.mapping.holder.VoxelShape;
import org.mtr.mapping.holder.VoxelShapes;
import org.mtr.mapping.mapper.BlockEntityExtension;
import org.mtr.mod.block.BlockPIDSHorizontalBase;
import org.mtr.mod.block.IBlock;
import top.mcmtr.mod.BlockEntityTypes;
import top.mcmtr.mod.config.Config;

public final class BlockYamanotePIDS
extends BlockPIDSHorizontalBase {
    private static final int MAX_ARRIVALS = 3;
    private final int length;

    public BlockYamanotePIDS(int length) {
        super(3);
        this.length = length;
    }

    public BlockEntityExtension createBlockEntity(BlockPos blockPos, BlockState blockState) {
        return new BlockYamanotePIDSEntity(this.length, blockPos, blockState);
    }

    public VoxelShape getOutlineShape2(BlockState state, BlockView world, BlockPos pos, ShapeContext context) {
        switch (this.length) {
            case 5: {
                VoxelShape shape1 = IBlock.getVoxelShapeByDirection((double)7.0, (double)8.0, (double)0.0, (double)9.0, (double)16.0, (double)21.0, (Direction)IBlock.getStatePropertySafe((BlockState)state, (DirectionProperty)FACING));
                VoxelShape shape2 = IBlock.getVoxelShapeByDirection((double)7.5, (double)8.0, (double)21.0, (double)8.5, (double)16.0, (double)22.0, (Direction)IBlock.getStatePropertySafe((BlockState)state, (DirectionProperty)FACING));
                return VoxelShapes.union((VoxelShape)shape1, (VoxelShape)shape2);
            }
            case 6: {
                VoxelShape shape1 = IBlock.getVoxelShapeByDirection((double)7.0, (double)8.0, (double)0.0, (double)9.0, (double)16.0, (double)25.0, (Direction)IBlock.getStatePropertySafe((BlockState)state, (DirectionProperty)FACING));
                VoxelShape shape2 = IBlock.getVoxelShapeByDirection((double)7.5, (double)8.0, (double)25.0, (double)8.5, (double)16.0, (double)26.0, (Direction)IBlock.getStatePropertySafe((BlockState)state, (DirectionProperty)FACING));
                return VoxelShapes.union((VoxelShape)shape1, (VoxelShape)shape2);
            }
            case 7: {
                VoxelShape shape1 = IBlock.getVoxelShapeByDirection((double)7.0, (double)8.0, (double)0.0, (double)9.0, (double)16.0, (double)29.0, (Direction)IBlock.getStatePropertySafe((BlockState)state, (DirectionProperty)FACING));
                VoxelShape shape2 = IBlock.getVoxelShapeByDirection((double)7.5, (double)8.0, (double)29.0, (double)8.5, (double)16.0, (double)30.0, (Direction)IBlock.getStatePropertySafe((BlockState)state, (DirectionProperty)FACING));
                return VoxelShapes.union((VoxelShape)shape1, (VoxelShape)shape2);
            }
        }
        VoxelShape shape1 = IBlock.getVoxelShapeByDirection((double)7.0, (double)8.0, (double)0.0, (double)9.0, (double)16.0, (double)17.0, (Direction)IBlock.getStatePropertySafe((BlockState)state, (DirectionProperty)FACING));
        VoxelShape shape2 = IBlock.getVoxelShapeByDirection((double)7.5, (double)8.0, (double)17.0, (double)8.5, (double)16.0, (double)18.0, (Direction)IBlock.getStatePropertySafe((BlockState)state, (DirectionProperty)FACING));
        return VoxelShapes.union((VoxelShape)shape1, (VoxelShape)shape2);
    }

    public int getLength() {
        return this.length;
    }

    public String getTranslationKey2() {
        return "block.msd.yamanote_pids";
    }

    public static class BlockYamanotePIDSEntity
    extends BlockPIDSHorizontalBase.BlockEntityHorizontalBase {
        public BlockYamanotePIDSEntity(int length, BlockPos pos, BlockState state) {
            super(3, BlockYamanotePIDSEntity.getEntity(length), pos, state);
        }

        public static BlockEntityType<? extends BlockEntityExtension> getEntity(int length) {
            switch (length) {
                case 5: {
                    return BlockEntityTypes.YAMANOTE_5_PIDS.get();
                }
                case 6: {
                    return BlockEntityTypes.YAMANOTE_6_PIDS.get();
                }
                case 7: {
                    return BlockEntityTypes.YAMANOTE_7_PIDS.get();
                }
            }
            return BlockEntityTypes.YAMANOTE_4_PIDS.get();
        }

        public boolean showArrivalNumber() {
            return true;
        }

        public double getRenderDistance2() {
            return Config.getYuuniPIDSMaxViewDistance();
        }
    }
}

