/*
 * Decompiled with CFR 0.152.
 */
package top.mcmtr.mod.blocks;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.class_2769;
import org.mtr.mapping.holder.ActionResult;
import org.mtr.mapping.holder.BlockEntity;
import org.mtr.mapping.holder.BlockEntityType;
import org.mtr.mapping.holder.BlockHitResult;
import org.mtr.mapping.holder.BlockPos;
import org.mtr.mapping.holder.BlockRenderType;
import org.mtr.mapping.holder.BlockState;
import org.mtr.mapping.holder.BlockView;
import org.mtr.mapping.holder.CompoundTag;
import org.mtr.mapping.holder.Hand;
import org.mtr.mapping.holder.ItemPlacementContext;
import org.mtr.mapping.holder.ItemStack;
import org.mtr.mapping.holder.MutableText;
import org.mtr.mapping.holder.PlayerEntity;
import org.mtr.mapping.holder.Property;
import org.mtr.mapping.holder.ServerPlayerEntity;
import org.mtr.mapping.holder.ServerWorld;
import org.mtr.mapping.holder.TextFormatting;
import org.mtr.mapping.holder.TooltipContext;
import org.mtr.mapping.holder.World;
import org.mtr.mapping.mapper.BlockEntityExtension;
import org.mtr.mapping.mapper.DirectionHelper;
import org.mtr.mapping.mapper.TextHelper;
import org.mtr.mapping.registry.PacketHandler;
import org.mtr.mapping.tool.HolderBase;
import org.mtr.mod.block.IBlock;
import top.mcmtr.core.data.OffsetPosition;
import top.mcmtr.mod.BlockEntityTypes;
import top.mcmtr.mod.Init;
import top.mcmtr.mod.blocks.BlockNodeBase;
import top.mcmtr.mod.packet.MSDPacketDeleteData;
import top.mcmtr.mod.packet.MSDPacketOpenCatenaryWithModelScreen;

public final class BlockCatenaryWithModel
extends BlockNodeBase
implements DirectionHelper {
    private final CatenaryModel catenaryModel;

    public BlockCatenaryWithModel(CatenaryModel catenaryModel) {
        this.catenaryModel = catenaryModel;
    }

    public void onBreak2(World world, BlockPos pos, BlockState state, PlayerEntity player) {
        if (!world.isClient()) {
            MSDPacketDeleteData.sendDirectlyToServerCatenaryNodePosition(ServerWorld.cast((HolderBase)world), org.mtr.mod.Init.blockPosToPosition((BlockPos)pos));
        }
    }

    public BlockRenderType getRenderType2(BlockState state) {
        return BlockRenderType.INVISIBLE;
    }

    @Override
    public void addBlockProperties(List<HolderBase<?>> properties) {
        properties.add((HolderBase<?>)FACING);
        properties.add((HolderBase<?>)IS_CONNECTED);
    }

    @Override
    public BlockState getPlacementState2(ItemPlacementContext ctx) {
        return this.getDefaultState2().with(new Property((class_2769)BlockCatenaryWithModel.IS_CONNECTED.data), (Comparable)Boolean.valueOf(false)).with(new Property((class_2769)BlockCatenaryWithModel.FACING.data), (Comparable)ctx.getPlayerFacing().data);
    }

    public ActionResult onUse2(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockHitResult hit) {
        return IBlock.checkHoldingBrush((World)world, (PlayerEntity)player, () -> {
            BlockEntity blockEntity = world.getBlockEntity(pos);
            if (blockEntity != null && blockEntity.data instanceof BlockCatenaryWithModelEntity) {
                Init.REGISTRY.sendPacketToClient(ServerPlayerEntity.cast((HolderBase)player), (PacketHandler)new MSDPacketOpenCatenaryWithModelScreen(pos, (Boolean)state.get(new Property((class_2769)BlockCatenaryWithModel.IS_CONNECTED.data))));
            }
        });
    }

    public BlockEntityExtension createBlockEntity(BlockPos blockPos, BlockState blockState) {
        return new BlockCatenaryWithModelEntity(this.catenaryModel, blockPos, blockState);
    }

    public String getTranslationKey2() {
        return "block.msd.blockCatenaryWithModel";
    }

    public void addTooltips(ItemStack stack, @Nullable BlockView world, List<MutableText> tooltip, TooltipContext options) {
        if (this.catenaryModel.isLong()) {
            tooltip.add(TextHelper.translatable((String)"tooltip.msd.catenary_reverse", (Object[])new Object[0]).formatted(TextFormatting.GOLD));
        } else {
            tooltip.add(TextHelper.translatable((String)"tooltip.msd.catenary_positive", (Object[])new Object[0]).formatted(TextFormatting.GOLD));
        }
        if (this.catenaryModel.isTop()) {
            tooltip.add(TextHelper.translatable((String)"tooltip.msd.catenary_top", (Object[])new Object[0]).formatted(TextFormatting.GRAY));
        }
        if (this.catenaryModel.isHasCounterweight()) {
            tooltip.add(TextHelper.translatable((String)"tooltip.msd.catenary_counterweight", (Object[])new Object[0]).formatted(TextFormatting.GRAY));
        }
        if (this.catenaryModel.isMirror()) {
            tooltip.add(TextHelper.translatable((String)"tooltip.msd.mirror", (Object[])new Object[0]).formatted(TextFormatting.GRAY));
        }
    }

    public static enum CatenaryModel {
        CATENARY_LONG("catenary_long", true, false, false, false),
        CATENARY_LONG_TOP("catenary_long_top", true, true, false, false),
        CATENARY_LONG_COUNTERWEIGHT("catenary_long_counterweight", true, false, true, false),
        CATENARY_LONG_COUNTERWEIGHT_MIRROR("catenary_long_counterweight_mirror", true, false, true, true),
        CATENARY_SHORT("catenary_short", false, false, false, false),
        CATENARY_SHORT_TOP("catenary_short_top", false, true, false, false),
        CATENARY_SHORT_COUNTERWEIGHT("catenary_short_counterweight", false, false, true, false),
        CATENARY_SHORT_COUNTERWEIGHT_MIRROR("catenary_short_counterweight_mirror", false, false, true, true);

        private final String modelId;
        private final boolean isLong;
        private final boolean isTop;
        private final boolean hasCounterweight;
        private final boolean isMirror;

        private CatenaryModel(String modelId, boolean isLong, boolean isTop, boolean hasCounterweight, boolean isMirror) {
            this.modelId = modelId;
            this.isLong = isLong;
            this.isTop = isTop;
            this.hasCounterweight = hasCounterweight;
            this.isMirror = isMirror;
        }

        public String getModelId() {
            return this.modelId;
        }

        public boolean isLong() {
            return this.isLong;
        }

        public boolean isTop() {
            return this.isTop;
        }

        public boolean isHasCounterweight() {
            return this.hasCounterweight;
        }

        public boolean isMirror() {
            return this.isMirror;
        }
    }

    public static final class BlockCatenaryWithModelEntity
    extends BlockNodeBase.BlockNodeBaseEntity {
        private static final String KEY_OFFSET_POSITION = "msd_offset_position_";
        private static final String KEY_ROTATE_POSITION = "msd_rotate_position_";
        private final OffsetPosition offsetPosition = new OffsetPosition(0.0, 0.0, 0.0);
        private final OffsetPosition rotation = new OffsetPosition(0.0, 0.0, 0.0);

        public BlockCatenaryWithModelEntity(CatenaryModel catenaryModel, BlockPos blockPos, BlockState blockState) {
            super(BlockCatenaryWithModelEntity.getType(catenaryModel), blockPos, blockState);
        }

        public void setOffsetPosition(OffsetPosition offsetPosition, OffsetPosition rotation) {
            this.offsetPosition.setX(offsetPosition.getX());
            this.offsetPosition.setY(offsetPosition.getY());
            this.offsetPosition.setZ(offsetPosition.getZ());
            this.rotation.setX(rotation.getX());
            this.rotation.setY(rotation.getY());
            this.rotation.setZ(rotation.getZ());
            this.markDirty2();
        }

        @Override
        public OffsetPosition getOffsetPosition() {
            return this.offsetPosition;
        }

        public OffsetPosition getRotation() {
            return this.rotation;
        }

        @Override
        public void readCompoundTag(CompoundTag compoundTag) {
            this.offsetPosition.setX(compoundTag.getDouble("msd_offset_position_x"));
            this.offsetPosition.setY(compoundTag.getDouble("msd_offset_position_y"));
            this.offsetPosition.setZ(compoundTag.getDouble("msd_offset_position_z"));
            this.rotation.setX(compoundTag.getDouble("msd_rotate_position_x"));
            this.rotation.setY(compoundTag.getDouble("msd_rotate_position_y"));
            this.rotation.setZ(compoundTag.getDouble("msd_rotate_position_z"));
        }

        @Override
        public void writeCompoundTag(CompoundTag compoundTag) {
            compoundTag.putDouble("msd_offset_position_x", this.offsetPosition.getX());
            compoundTag.putDouble("msd_offset_position_y", this.offsetPosition.getY());
            compoundTag.putDouble("msd_offset_position_z", this.offsetPosition.getZ());
            compoundTag.putDouble("msd_rotate_position_x", this.rotation.getX());
            compoundTag.putDouble("msd_rotate_position_y", this.rotation.getY());
            compoundTag.putDouble("msd_rotate_position_z", this.rotation.getZ());
        }

        private static BlockEntityType<? extends BlockNodeBase.BlockNodeBaseEntity> getType(CatenaryModel catenaryModel) {
            switch (catenaryModel) {
                case CATENARY_SHORT: {
                    return BlockEntityTypes.CATENARY_WITH_SHORT.get();
                }
                case CATENARY_LONG_TOP: {
                    return BlockEntityTypes.CATENARY_WITH_LONG_TOP.get();
                }
                case CATENARY_SHORT_TOP: {
                    return BlockEntityTypes.CATENARY_WITH_SHORT_TOP.get();
                }
                case CATENARY_LONG_COUNTERWEIGHT: {
                    return BlockEntityTypes.CATENARY_WITH_LONG_COUNTERWEIGHT.get();
                }
                case CATENARY_SHORT_COUNTERWEIGHT: {
                    return BlockEntityTypes.CATENARY_WITH_SHORT_COUNTERWEIGHT.get();
                }
                case CATENARY_LONG_COUNTERWEIGHT_MIRROR: {
                    return BlockEntityTypes.CATENARY_WITH_LONG_COUNTERWEIGHT_MIRROR.get();
                }
                case CATENARY_SHORT_COUNTERWEIGHT_MIRROR: {
                    return BlockEntityTypes.CATENARY_WITH_SHORT_COUNTERWEIGHT_MIRROR.get();
                }
            }
            return BlockEntityTypes.CATENARY_WITH_LONG.get();
        }
    }
}

