/*
 * Decompiled with CFR 0.152.
 */
package top.mcmtr.core.simulation;

import java.nio.file.Path;
import org.mtr.core.serializer.SerializedDataBaseWithId;
import org.mtr.core.servlet.MessageQueue;
import org.mtr.core.servlet.QueueObject;
import org.mtr.core.simulation.FileLoader;
import org.mtr.core.tool.Utilities;
import org.mtr.libraries.it.unimi.dsi.fastutil.ints.IntIntImmutablePair;
import org.mtr.libraries.it.unimi.dsi.fastutil.objects.ObjectArraySet;
import org.mtr.libraries.it.unimi.dsi.fastutil.objects.ObjectLongImmutablePair;
import org.mtr.libraries.it.unimi.dsi.fastutil.objects.ObjectSet;
import top.mcmtr.core.MSDMain;
import top.mcmtr.core.data.Catenary;
import top.mcmtr.core.data.MSDData;
import top.mcmtr.core.data.RigidCatenary;
import top.mcmtr.core.legacy.data.LegacyCatenaryLoader;
import top.mcmtr.core.servlet.MSDOperationProcessor;

public class MSDSimulator
extends MSDData
implements Utilities {
    private boolean autoSave = false;
    private final String dimension;
    private final FileLoader<Catenary> fileLoaderCatenaries;
    private final FileLoader<RigidCatenary> fileLoaderRigidCatenaries;
    private final MessageQueue<Runnable> queuedRuns = new MessageQueue();
    private final MessageQueue<QueueObject> messageQueueC2S = new MessageQueue();
    private static final String KEY_CATENARIES = "catenaries";
    private static final String KEY_RIGID_CATENARIES = "rigid_catenaries";

    public MSDSimulator(String dimension, Path rootPath) {
        this.dimension = dimension;
        long startMillis = System.currentTimeMillis();
        Path savePath = rootPath.resolve(dimension);
        LegacyCatenaryLoader.loadCatenary(savePath, (ObjectArraySet<Catenary>)this.catenaries);
        LegacyCatenaryLoader.loadTransCatenary(savePath, (ObjectArraySet<Catenary>)this.catenaries);
        LegacyCatenaryLoader.loadRigidCatenary(savePath, (ObjectArraySet<RigidCatenary>)this.rigidCatenaries);
        this.fileLoaderCatenaries = new FileLoader((ObjectSet)this.catenaries, Catenary::new, savePath, KEY_CATENARIES);
        this.fileLoaderRigidCatenaries = new FileLoader((ObjectSet)this.rigidCatenaries, RigidCatenary::new, savePath, KEY_RIGID_CATENARIES);
        long endMillis = System.currentTimeMillis();
        MSDMain.MSD_CORE_LOG.debug("MSD Data loading complete for {} in {} second(s)", (Object)dimension, (Object)Float.valueOf((float)(endMillis - startMillis) / 1000.0f));
        this.sync();
    }

    public void tick() {
        try {
            if (this.autoSave) {
                this.save(true);
                this.autoSave = false;
            }
            this.queuedRuns.process(Runnable::run);
            this.messageQueueC2S.process(queueObject -> queueObject.runCallback(MSDOperationProcessor.process(queueObject.key, queueObject.data, this)));
        }
        catch (Exception e) {
            MSDMain.MSD_CORE_LOG.error("MSD Simulator tick error", (Throwable)e);
            throw e;
        }
    }

    public void save() {
        this.autoSave = true;
    }

    public void stop() {
        this.save(false);
    }

    public void run(Runnable runnable) {
        this.queuedRuns.put((Object)runnable);
    }

    public void sendMessageC2S(QueueObject queueObject) {
        this.messageQueueC2S.put((Object)queueObject);
    }

    private void save(boolean useReducedHash) {
        ObjectLongImmutablePair changedAndDuration = Utilities.measureDuration(() -> {
            boolean changed1 = this.save(this.fileLoaderCatenaries, useReducedHash);
            boolean changed2 = this.save(this.fileLoaderRigidCatenaries, useReducedHash);
            return changed1 || changed2;
        });
        if (((Boolean)changedAndDuration.left()).booleanValue() || !useReducedHash) {
            MSDMain.MSD_CORE_LOG.debug("MSD Save complete for {} in {} second(s)", (Object)this.dimension, (Object)Float.valueOf((float)changedAndDuration.rightLong() / 1000.0f));
        }
    }

    private <T extends SerializedDataBaseWithId> boolean save(FileLoader<T> fileLoader, boolean useReducedHash) {
        int deletedCount;
        IntIntImmutablePair saveCounts = fileLoader.save(useReducedHash);
        int changedCount = saveCounts.leftInt();
        if (changedCount > 0) {
            MSDMain.MSD_CORE_LOG.debug("- MSD Changed {}: {}", (Object)fileLoader.key, (Object)saveCounts.leftInt());
        }
        if ((deletedCount = saveCounts.rightInt()) > 0) {
            MSDMain.MSD_CORE_LOG.debug("- MSD Deleted {}: {}", (Object)fileLoader.key, (Object)saveCounts.rightInt());
        }
        return changedCount > 0 || deletedCount > 0;
    }
}

