/*
 * Decompiled with CFR 0.152.
 */
package top.mcmtr.core.operation;

import java.util.Collection;
import org.mtr.core.serializer.ReaderBase;
import top.mcmtr.core.data.Catenary;
import top.mcmtr.core.data.MSDClientData;
import top.mcmtr.core.data.MSDData;
import top.mcmtr.core.data.RigidCatenary;
import top.mcmtr.core.generated.operation.MSDDataResponseSchema;

public final class MSDDataResponse
extends MSDDataResponseSchema {
    private final MSDData data;

    public MSDDataResponse(MSDData data) {
        this.data = data;
    }

    public MSDDataResponse(ReaderBase readerBase, MSDClientData data) {
        super(readerBase);
        this.data = data;
        this.updateData(readerBase);
    }

    public void write() {
        if (this.data instanceof MSDClientData) {
            this.data.catenaries.removeIf(catenary -> !this.catenariesToKeep.contains((Object)catenary.getHexId()));
            this.data.catenaries.addAll((Collection)this.catenaries);
            this.data.rigidCatenaries.removeIf(rigidCatenary -> !this.rigidCatenariesToKeep.contains((Object)rigidCatenary.getHexId()));
            this.data.rigidCatenaries.addAll((Collection)this.rigidCatenaries);
            this.data.sync();
        }
    }

    void addCatenary(Catenary catenary) {
        this.catenaries.add((Object)catenary);
    }

    void addRigidCatenary(RigidCatenary rigidCatenary) {
        this.rigidCatenaries.add((Object)rigidCatenary);
    }

    void addCatenary(String catenaryId) {
        this.catenariesToKeep.add((Object)catenaryId);
    }

    void addRigidCatenary(String rigidCatenaryId) {
        this.rigidCatenariesToKeep.add((Object)rigidCatenaryId);
    }
}

