/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.logistics.tunnel;

import com.jozufozu.flywheel.backend.instancing.InstancedRenderDispatcher;
import com.simibubi.create.AllPackets;
import com.simibubi.create.content.kinetics.belt.BeltBlockEntity;
import com.simibubi.create.content.kinetics.belt.transport.ItemHandlerBeltSegment;
import com.simibubi.create.content.logistics.funnel.BeltFunnelBlock;
import com.simibubi.create.content.logistics.tunnel.BeltTunnelBlock;
import com.simibubi.create.content.logistics.tunnel.TunnelFlapPacket;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.utility.Iterate;
import com.simibubi.create.foundation.utility.animation.LerpedFloat;
import com.tterrag.registrate.fabric.EnvExecutor;
import io.github.fabricators_of_create.porting_lib.util.StorageProvider;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import me.pepperbell.simplenetworking.S2CPacket;
import net.fabricmc.api.EnvType;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.storage.base.SidedStorageBlockEntity;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2497;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.Nullable;

public class BeltTunnelBlockEntity
extends SmartBlockEntity
implements SidedStorageBlockEntity {
    public Map<class_2350, LerpedFloat> flaps = new EnumMap<class_2350, LerpedFloat>(class_2350.class);
    public Set<class_2350> sides = new HashSet<class_2350>();
    protected StorageProvider<ItemVariant> belowProvider;
    protected List<Pair<class_2350, Boolean>> flapsToSend = new LinkedList<Pair<class_2350, Boolean>>();

    public BeltTunnelBlockEntity(class_2591<?> type, class_2338 pos, class_2680 state) {
        super(type, pos, state);
    }

    public void method_31662(class_1937 level) {
        super.method_31662(level);
        this.belowProvider = StorageProvider.createForItems((class_1937)level, (class_2338)this.field_11867.method_10074()).filter(this::isBeltStorage);
    }

    public boolean isBeltStorage(StorageProvider<ItemVariant> provider, Storage<ItemVariant> storage) {
        return storage instanceof ItemHandlerBeltSegment;
    }

    @Override
    public void invalidate() {
        super.invalidate();
    }

    protected void writeFlapsAndSides(class_2487 compound) {
        class_2499 flapsNBT = new class_2499();
        for (class_2350 direction : this.flaps.keySet()) {
            flapsNBT.add((Object)class_2497.method_23247((int)direction.method_10146()));
        }
        compound.method_10566("Flaps", (class_2520)flapsNBT);
        class_2499 sidesNBT = new class_2499();
        for (class_2350 direction : this.sides) {
            sidesNBT.add((Object)class_2497.method_23247((int)direction.method_10146()));
        }
        compound.method_10566("Sides", (class_2520)sidesNBT);
    }

    @Override
    public void writeSafe(class_2487 tag) {
        this.writeFlapsAndSides(tag);
        super.writeSafe(tag);
    }

    @Override
    public void write(class_2487 compound, boolean clientPacket) {
        this.writeFlapsAndSides(compound);
        super.write(compound, clientPacket);
    }

    @Override
    protected void read(class_2487 compound, boolean clientPacket) {
        HashSet<class_2350> newFlaps = new HashSet<class_2350>(6);
        class_2499 flapsNBT = compound.method_10554("Flaps", 3);
        for (class_2520 inbt : flapsNBT) {
            if (!(inbt instanceof class_2497)) continue;
            newFlaps.add(class_2350.method_10143((int)((class_2497)inbt).method_10701()));
        }
        this.sides.clear();
        class_2499 sidesNBT = compound.method_10554("Sides", 3);
        for (class_2520 inbt : sidesNBT) {
            if (!(inbt instanceof class_2497)) continue;
            this.sides.add(class_2350.method_10143((int)((class_2497)inbt).method_10701()));
        }
        for (class_2350 d : Iterate.directions) {
            if (!newFlaps.contains(d)) {
                this.flaps.remove(d);
                continue;
            }
            if (this.flaps.containsKey(d)) continue;
            this.flaps.put(d, this.createChasingFlap());
        }
        if (!compound.method_10545("Sides") && compound.method_10545("Flaps")) {
            this.sides.addAll(this.flaps.keySet());
        }
        super.read(compound, clientPacket);
        if (clientPacket) {
            EnvExecutor.runWhenOn((EnvType)EnvType.CLIENT, () -> () -> InstancedRenderDispatcher.enqueueUpdate((class_2586)this));
        }
    }

    private LerpedFloat createChasingFlap() {
        return LerpedFloat.linear().startWithValue(0.25).chase(0.0, 0.05f, LerpedFloat.Chaser.EXP);
    }

    public void updateTunnelConnections() {
        this.flaps.clear();
        this.sides.clear();
        class_2680 tunnelState = this.method_11010();
        for (class_2350 direction : Iterate.horizontalDirections) {
            if (direction.method_10166() != tunnelState.method_11654((class_2769)class_2741.field_12529)) {
                boolean positive = direction.method_10171() == class_2350.class_2352.field_11056 ^ direction.method_10166() == class_2350.class_2351.field_11051;
                BeltTunnelBlock.Shape shape = (BeltTunnelBlock.Shape)((Object)tunnelState.method_11654(BeltTunnelBlock.SHAPE));
                if (BeltTunnelBlock.isStraight(tunnelState) || positive && shape == BeltTunnelBlock.Shape.T_LEFT || !positive && shape == BeltTunnelBlock.Shape.T_RIGHT) continue;
            }
            this.sides.add(direction);
            class_2680 nextState = this.field_11863.method_8320(this.field_11867.method_10093(direction));
            if (nextState.method_26204() instanceof BeltTunnelBlock || nextState.method_26204() instanceof BeltFunnelBlock && nextState.method_11654(BeltFunnelBlock.SHAPE) == BeltFunnelBlock.Shape.EXTENDED && nextState.method_11654((class_2769)BeltFunnelBlock.HORIZONTAL_FACING) == direction.method_10153()) continue;
            this.flaps.put(direction, this.createChasingFlap());
        }
        this.sendData();
    }

    public void flap(class_2350 side, boolean inward) {
        if (this.field_11863.field_9236) {
            if (this.flaps.containsKey(side)) {
                this.flaps.get(side).setValue(inward ^ side.method_10166() == class_2350.class_2351.field_11051 ? -1.0 : 1.0);
            }
            return;
        }
        this.flapsToSend.add((Pair<class_2350, Boolean>)Pair.of((Object)side, (Object)inward));
    }

    @Override
    public void initialize() {
        super.initialize();
        this.updateTunnelConnections();
    }

    @Override
    public void tick() {
        super.tick();
        if (!this.field_11863.field_9236) {
            if (!this.flapsToSend.isEmpty()) {
                this.sendFlaps();
            }
            return;
        }
        this.flaps.forEach((d, value) -> value.tickChaser());
    }

    private void sendFlaps() {
        AllPackets.getChannel().sendToClientsTracking((S2CPacket)new TunnelFlapPacket(this, this.flapsToSend), (class_3218)this.field_11863, this.method_11016());
        this.flapsToSend.clear();
    }

    @Override
    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
    }

    public Storage<ItemVariant> getItemStorage(@Nullable class_2350 face) {
        if (this.belowProvider == null) {
            return null;
        }
        if (this.belowProvider.findBlockEntity() instanceof BeltBlockEntity) {
            return this.belowProvider.get(class_2350.field_11036);
        }
        return null;
    }
}

