/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.equipment.bell;

import com.jozufozu.flywheel.core.PartialModel;
import com.simibubi.create.AllPartialModels;
import com.simibubi.create.content.equipment.bell.AbstractBellBlockEntity;
import com.simibubi.create.content.equipment.bell.HauntedBellPulser;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2487;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_5819;

public class HauntedBellBlockEntity
extends AbstractBellBlockEntity {
    public static final int DISTANCE = 10;
    public static final int RECHARGE_TICKS = 65;
    public static final int EFFECT_TICKS = 20;
    public int effectTicks = 0;

    public HauntedBellBlockEntity(class_2591<?> type, class_2338 pos, class_2680 state) {
        super(type, pos, state);
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public PartialModel getBellModel() {
        return AllPartialModels.HAUNTED_BELL;
    }

    @Override
    public boolean ring(class_1937 world, class_2338 pos, class_2350 direction) {
        if (this.isRinging && this.ringingTicks < 65) {
            return false;
        }
        HauntedBellPulser.sendPulse(world, pos, 10, false);
        this.effectTicks = 20;
        return super.ring(world, pos, direction);
    }

    @Override
    protected void write(class_2487 compound, boolean clientPacket) {
        super.write(compound, clientPacket);
        compound.method_10569("EffectTicks", this.effectTicks);
    }

    @Override
    protected void read(class_2487 compound, boolean clientPacket) {
        super.read(compound, clientPacket);
        this.effectTicks = compound.method_10550("EffectTicks");
    }

    @Override
    public void tick() {
        super.tick();
        if (this.effectTicks <= 0) {
            return;
        }
        --this.effectTicks;
        if (!this.field_11863.field_9236) {
            return;
        }
        class_5819 rand = this.field_11863.method_8409();
        if (rand.method_43057() > 0.25f) {
            return;
        }
        this.spawnParticle(rand);
        this.playSound(rand);
    }

    protected void spawnParticle(class_5819 rand) {
        double x = (double)this.field_11867.method_10263() + rand.method_43058();
        double y = (double)this.field_11867.method_10264() + 0.5;
        double z = (double)this.field_11867.method_10260() + rand.method_43058();
        double vx = rand.method_43058() * 0.04 - 0.02;
        double vy = 0.1;
        double vz = rand.method_43058() * 0.04 - 0.02;
        this.field_11863.method_8406((class_2394)class_2398.field_23114, x, y, z, vx, vy, vz);
    }

    protected void playSound(class_5819 rand) {
        float vol = rand.method_43057() * 0.4f + rand.method_43057() > 0.9f ? 0.6f : 0.0f;
        float pitch = 0.6f + rand.method_43057() * 0.4f;
        this.field_11863.method_8396(null, this.field_11867, class_3417.field_23060, class_3419.field_15245, vol, pitch);
    }
}

