/*
 * Decompiled with CFR 0.152.
 */
package com.lx862.mtrscripting.lib.org.mozilla.javascript;

import com.lx862.mtrscripting.lib.org.mozilla.javascript.Context;
import com.lx862.mtrscripting.lib.org.mozilla.javascript.NativeError;
import com.lx862.mtrscripting.lib.org.mozilla.javascript.RhinoException;
import com.lx862.mtrscripting.lib.org.mozilla.javascript.ScriptRuntime;
import com.lx862.mtrscripting.lib.org.mozilla.javascript.Scriptable;
import com.lx862.mtrscripting.lib.org.mozilla.javascript.Wrapper;

public class JavaScriptException
extends RhinoException {
    private static final long serialVersionUID = -7666130513694669293L;
    private Object value;
    private String details;

    @Deprecated
    public JavaScriptException(Object value) {
        this(value, "", 0);
    }

    public JavaScriptException(Object value, String sourceName, int lineNumber) {
        this.recordErrorOrigin(sourceName, lineNumber, null, 0);
        this.value = value;
        Object javaCause = value;
        if (value instanceof NativeError) {
            NativeError error = (NativeError)value;
            javaCause = error.get("javaException", (Scriptable)error);
            if (Context.getContext().hasFeature(10)) {
                if (!error.has("fileName", (Scriptable)error)) {
                    error.put("fileName", (Scriptable)error, (Object)sourceName);
                }
                if (!error.has("lineNumber", (Scriptable)error)) {
                    error.put("lineNumber", (Scriptable)error, (Object)lineNumber);
                }
                error.setStackProvider(this);
            }
        }
        if (javaCause instanceof Wrapper) {
            javaCause = ((Wrapper)javaCause).unwrap();
        }
        if (javaCause instanceof Throwable) {
            this.initCause((Throwable)javaCause);
        }
        this.details = this.getDetails();
    }

    @Override
    public String details() {
        return this.details;
    }

    public String getDetails() {
        if (this.value == null) {
            return "null";
        }
        if (this.value instanceof NativeError) {
            return this.value.toString();
        }
        try {
            return ScriptRuntime.toString(this.value);
        }
        catch (RuntimeException rte) {
            if (this.value instanceof Scriptable) {
                return ScriptRuntime.defaultObjectToString((Scriptable)this.value);
            }
            return this.value.toString();
        }
    }

    public Object getValue() {
        return this.value;
    }

    @Deprecated
    public String getSourceName() {
        return this.sourceName();
    }

    @Deprecated
    public int getLineNumber() {
        return this.lineNumber();
    }
}

