/*
 * Decompiled with CFR 0.152.
 */
package com.lx862.mtrscripting.lib.org.mozilla.javascript;

import com.lx862.mtrscripting.lib.org.mozilla.javascript.BaseFunction;
import com.lx862.mtrscripting.lib.org.mozilla.javascript.Callable;
import com.lx862.mtrscripting.lib.org.mozilla.javascript.Context;
import com.lx862.mtrscripting.lib.org.mozilla.javascript.DecompilerFlag;
import com.lx862.mtrscripting.lib.org.mozilla.javascript.EqualObjectGraphs;
import com.lx862.mtrscripting.lib.org.mozilla.javascript.Function;
import com.lx862.mtrscripting.lib.org.mozilla.javascript.NativeObject;
import com.lx862.mtrscripting.lib.org.mozilla.javascript.ScriptRuntime;
import com.lx862.mtrscripting.lib.org.mozilla.javascript.Scriptable;
import com.lx862.mtrscripting.lib.org.mozilla.javascript.TopLevel;
import java.util.EnumSet;

public class ArrowFunction
extends BaseFunction {
    private static final long serialVersionUID = -7377989503697220633L;
    private final Callable targetFunction;
    private final Scriptable boundThis;
    private final Scriptable boundHomeObject;

    public ArrowFunction(Context cx, Scriptable scope, Callable targetFunction, Scriptable boundThis, Scriptable boundHomeObject) {
        this.targetFunction = targetFunction;
        this.boundThis = boundThis;
        this.boundHomeObject = boundHomeObject;
        ScriptRuntime.setFunctionProtoAndParent(this, cx, scope, false);
        BaseFunction thrower = ScriptRuntime.typeErrorThrower(cx);
        NativeObject throwing = new NativeObject();
        ScriptRuntime.setBuiltinProtoAndParent(throwing, scope, TopLevel.Builtins.Object);
        throwing.put("get", (Scriptable)throwing, (Object)thrower);
        throwing.put("set", (Scriptable)throwing, (Object)thrower);
        throwing.put("enumerable", (Scriptable)throwing, (Object)Boolean.FALSE);
        throwing.put("configurable", (Scriptable)throwing, (Object)Boolean.FALSE);
        throwing.preventExtensions();
        this.defineOwnProperty(cx, "caller", throwing, false);
        this.defineOwnProperty(cx, "arguments", throwing, false);
    }

    @Override
    public Object call(Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
        return this.targetFunction.call(cx, scope, this.getCallThis(cx), args);
    }

    @Override
    public Scriptable construct(Context cx, Scriptable scope, Object[] args) {
        throw ScriptRuntime.typeErrorById("msg.not.ctor", this.decompile(0, EnumSet.noneOf(DecompilerFlag.class)));
    }

    @Override
    public boolean hasInstance(Scriptable instance) {
        if (this.targetFunction instanceof Function) {
            return ((Function)this.targetFunction).hasInstance(instance);
        }
        throw ScriptRuntime.typeErrorById("msg.not.ctor", new Object[0]);
    }

    @Override
    public int getLength() {
        if (this.targetFunction instanceof BaseFunction) {
            return ((BaseFunction)this.targetFunction).getLength();
        }
        return 0;
    }

    @Override
    public int getArity() {
        return this.getLength();
    }

    @Override
    String decompile(int indent, EnumSet<DecompilerFlag> flags) {
        if (this.targetFunction instanceof BaseFunction) {
            return ((BaseFunction)this.targetFunction).decompile(indent, flags);
        }
        return super.decompile(indent, flags);
    }

    Scriptable getCallThis(Context cx) {
        return this.boundThis != null ? this.boundThis : ScriptRuntime.getTopCallScope(cx);
    }

    Scriptable getBoundHomeObject() {
        return this.boundHomeObject;
    }

    Callable getTargetFunction() {
        return this.targetFunction;
    }

    static boolean equalObjectGraphs(ArrowFunction f1, ArrowFunction f2, EqualObjectGraphs eq) {
        return eq.equalGraphs(f1.boundThis, f2.boundThis) && eq.equalGraphs(f1.targetFunction, f2.targetFunction);
    }
}

