/*
 * Decompiled with CFR 0.152.
 */
package com.lx862.mtrscripting;

import com.lx862.mtrscripting.ScriptInstanceManager;
import com.lx862.mtrscripting.core.MTRClassShutter;
import com.lx862.mtrscripting.core.ParsedScript;
import com.lx862.mtrscripting.data.ScriptContent;
import com.lx862.mtrscripting.lib.org.mozilla.javascript.Context;
import com.lx862.mtrscripting.lib.org.mozilla.javascript.Scriptable;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.util.TriConsumer;

public class ScriptManager {
    public static final Logger LOGGER = LogManager.getLogger((String)"MTR Scripting via JCM");
    private final ObjectList<TriConsumer<String, Context, Scriptable>> onParseScriptCallback = new ObjectArrayList();
    private final MTRClassShutter classShutter;
    private final ScriptInstanceManager instanceManager;
    private final List<ExecutorService> scriptExecutors;
    private int nextScriptExecutor = 0;

    public ScriptManager(List<ExecutorService> scriptExecutors) {
        if (scriptExecutors == null || scriptExecutors.isEmpty()) {
            throw new IllegalArgumentException("At least 1 script executors must be passed to ScriptManager!");
        }
        this.instanceManager = new ScriptInstanceManager();
        this.scriptExecutors = scriptExecutors;
        this.classShutter = new MTRClassShutter();
    }

    public ScriptInstanceManager getInstanceManager() {
        return this.instanceManager;
    }

    public void onParseScript(String contextName, Context context, Scriptable scriptable) {
        for (TriConsumer entry : this.onParseScriptCallback) {
            entry.accept((Object)contextName, (Object)context, (Object)scriptable);
        }
    }

    public void onParseScript(TriConsumer<String, Context, Scriptable> callback) {
        this.onParseScriptCallback.add(callback);
    }

    public MTRClassShutter getClassShutter() {
        return this.classShutter;
    }

    public ParsedScript parseScript(String scriptName, String contextName, List<ScriptContent> scripts) {
        try {
            return new ParsedScript(this, scriptName, contextName, scripts);
        }
        catch (NoSuchMethodException e) {
            LOGGER.error("[JCM Scripting] Fatal error: Cannot find required java method to add to script!", (Throwable)e);
            return null;
        }
    }

    public ExecutorService getDesignatedScriptExecutor() {
        ExecutorService executor = this.scriptExecutors.get(this.nextScriptExecutor);
        this.nextScriptExecutor = (this.nextScriptExecutor + 1) % this.scriptExecutors.size();
        return executor;
    }

    public void reset() {
        this.instanceManager.reset();
    }

    public Future<?> submitScriptTask(ExecutorService executorService, Runnable runnable) {
        return executorService.submit(runnable);
    }
}

