/*
 * Decompiled with CFR 0.152.
 */
package com.lx862.jcm.mod.scripting.jcm.pids;

import com.lx862.jcm.mod.scripting.jcm.pids.ArrivalWrapper;
import java.util.function.Consumer;
import org.mtr.core.data.Platform;
import org.mtr.core.operation.ArrivalResponse;
import org.mtr.libraries.it.unimi.dsi.fastutil.objects.ObjectArrayList;

public class ArrivalsWrapper {
    public final ObjectArrayList<ArrivalWrapper> arrivals = new ObjectArrayList();

    public ArrivalsWrapper(ObjectArrayList<ArrivalResponse> arrivalsResponse) {
        for (ArrivalResponse arrivalResponse : arrivalsResponse) {
            this.arrivals.add((Object)new ArrivalWrapper(arrivalResponse));
        }
    }

    public ArrivalWrapper get(int i) {
        return i >= this.arrivals.size() ? null : (ArrivalWrapper)this.arrivals.get(i);
    }

    public boolean mixedCarLength() {
        int car = -1;
        for (ArrivalWrapper arrivalResponse : this.arrivals) {
            if (car == -1) {
                car = arrivalResponse.carCount();
            }
            if (car == arrivalResponse.carCount()) continue;
            return true;
        }
        return false;
    }

    public ObjectArrayList<Platform> platforms() {
        ObjectArrayList platforms = new ObjectArrayList();
        for (ArrivalWrapper wrapper : this.arrivals) {
            Platform plat = wrapper.platform();
            if (plat == null || platforms.contains((Object)plat)) continue;
            platforms.add((Object)plat);
        }
        return platforms;
    }

    public void forEach(Consumer<ArrivalWrapper> consumer) {
        for (ArrivalWrapper arrivalResponse : this.arrivals) {
            consumer.accept(arrivalResponse);
        }
    }

    public void forEach(long platformId, Consumer<ArrivalWrapper> consumer) {
        for (ArrivalWrapper arrivalResponse : this.arrivals) {
            if (arrivalResponse.platformId() != platformId) continue;
            consumer.accept(arrivalResponse);
        }
    }
}

