/*
 * Decompiled with CFR 0.152.
 */
package com.lx862.jcm.mod.render.block;

import com.lx862.jcm.mod.Constants;
import com.lx862.jcm.mod.block.entity.PIDSProjectorBlockEntity;
import com.lx862.jcm.mod.data.pids.preset.PIDSPresetBase;
import com.lx862.jcm.mod.render.RenderHelper;
import com.lx862.jcm.mod.render.block.PIDSRenderer;
import com.lx862.jcm.mod.util.JCMUtil;
import org.mtr.core.operation.ArrivalResponse;
import org.mtr.libraries.it.unimi.dsi.fastutil.objects.ObjectArrayList;
import org.mtr.mapping.holder.BlockPos;
import org.mtr.mapping.holder.BlockState;
import org.mtr.mapping.holder.Direction;
import org.mtr.mapping.holder.Identifier;
import org.mtr.mapping.holder.MinecraftClient;
import org.mtr.mapping.holder.PlayerEntity;
import org.mtr.mapping.holder.RenderLayer;
import org.mtr.mapping.holder.World;
import org.mtr.mapping.mapper.BlockEntityRenderer;
import org.mtr.mapping.mapper.GraphicsHolder;
import org.mtr.mapping.tool.HolderBase;
import org.mtr.mod.render.MainRenderer;
import org.mtr.mod.render.QueuedRenderLayer;
import org.mtr.mod.render.StoredMatrixTransformations;

public class PIDSProjectorRenderer
extends PIDSRenderer<PIDSProjectorBlockEntity> {
    public PIDSProjectorRenderer(BlockEntityRenderer.Argument dispatcher) {
        super(dispatcher);
    }

    @Override
    public void renderPIDS(PIDSProjectorBlockEntity blockEntity, PIDSPresetBase pidsPreset, GraphicsHolder graphicsHolder, StoredMatrixTransformations storedMatrixTransformations, World world, BlockState state, BlockPos pos, Direction facing, ObjectArrayList<ArrivalResponse> arrivals, float tickDelta, boolean[] rowHidden) {
        float appliedScale = (float)blockEntity.getScale();
        float offsetX = (float)(0.5 - blockEntity.getOffsetX());
        float offsetY = (float)(0.5 + blockEntity.getOffsetY());
        float offsetZ = (float)(-0.5 - blockEntity.getOffsetZ());
        boolean showOutline = JCMUtil.playerHoldingBrush(PlayerEntity.cast((HolderBase)MinecraftClient.getInstance().getPlayerMapped()));
        storedMatrixTransformations.add(graphicsHolderNew -> {
            graphicsHolderNew.rotateYDegrees(90.0f);
            graphicsHolderNew.translate(-0.5 + blockEntity.getOffsetX(), -0.5 - blockEntity.getOffsetY(), 0.5 + blockEntity.getOffsetZ());
            graphicsHolderNew.rotateXDegrees((float)blockEntity.getRotateX());
            graphicsHolderNew.rotateYDegrees((float)blockEntity.getRotateY());
            graphicsHolderNew.rotateZDegrees((float)blockEntity.getRotateZ());
        });
        if (showOutline && blockEntity.getRotateX() == 0.0 && blockEntity.getRotateY() == 0.0 && blockEntity.getRotateZ() == 0.0) {
            MainRenderer.scheduleRender((QueuedRenderLayer)QueuedRenderLayer.LINES, (graphicsHolderNew, offset) -> {
                storedMatrixTransformations.transform(graphicsHolderNew, offset);
                graphicsHolderNew.createVertexConsumer(RenderLayer.getLines());
                graphicsHolderNew.drawLineInWorld(offsetX, offsetY, offsetZ, 0.0f, 0.0f, 0.0f, -65536);
                graphicsHolderNew.drawLineInWorld(offsetX, offsetY, offsetZ, 0.0f + 1.785f * appliedScale, 0.0f, 0.0f, -65536);
                graphicsHolderNew.drawLineInWorld(offsetX, offsetY, offsetZ, 0.0f, 0.0f + 1.0f * appliedScale, 0.0f, -65536);
                graphicsHolderNew.drawLineInWorld(offsetX, offsetY, offsetZ, 0.0f + 1.785f * appliedScale, 0.0f + 1.0f * appliedScale, 0.0f, -65536);
                graphicsHolderNew.pop();
            });
        }
        StoredMatrixTransformations newMatrices = storedMatrixTransformations.copy();
        newMatrices.add(graphicsHolderNew -> {
            graphicsHolderNew.scale(1.26315f, 1.26315f, 1.26315f);
            graphicsHolderNew.scale(appliedScale, appliedScale, appliedScale);
        });
        pidsPreset.render(blockEntity, graphicsHolder, newMatrices.copy(), world, blockEntity.getPos2(), facing, arrivals, rowHidden, tickDelta, 0, 0, 136, 76);
        if (showOutline) {
            MainRenderer.scheduleRender((QueuedRenderLayer)QueuedRenderLayer.LIGHT, (graphicsHolderNew, offset) -> {
                newMatrices.transform(graphicsHolderNew, offset);
                graphicsHolderNew.scale(0.010416667f, 0.010416667f, 0.010416667f);
                graphicsHolderNew.createVertexConsumer(RenderLayer.getBeaconBeam((Identifier)Constants.id("textures/block/light_1.png"), (boolean)false));
                RenderHelper.drawTexture(graphicsHolderNew, -1.0f, -1.0f, 0.1f, 138.0f, 78.0f, facing, -65536, 0xF000F0);
                graphicsHolderNew.pop();
            });
        }
    }
}

