/*
 * Decompiled with CFR 0.152.
 */
package com.lx862.jcm.mod.data;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.lx862.jcm.mod.data.TransactionEntry;
import com.lx862.jcm.mod.util.JCMLogger;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.mtr.mapping.holder.MinecraftServer;
import org.mtr.mapping.holder.PlayerEntity;
import org.mtr.mapping.holder.WorldSavePath;

public class TransactionHistoryManager {
    public static final int MAX_ENTRY_LIMIT = 50;
    private static final Gson gson = new GsonBuilder().setPrettyPrinting().create();
    private static final JsonParser jsonParser = new JsonParser();

    public static void appendEntry(PlayerEntity player, TransactionEntry newEntry) {
        List<TransactionEntry> newEntries = TransactionHistoryManager.getLogs(player);
        newEntries.add(newEntry);
        TransactionHistoryManager.saveLogs(newEntries, player);
    }

    private static void saveLogs(List<TransactionEntry> entries, PlayerEntity player) {
        try {
            Path savePath = TransactionHistoryManager.getSavePath(player.getServer(), player.getUuidAsString());
            savePath.getParent().toFile().mkdirs();
            Collections.sort(entries, (a, b) -> (int)(b.time() - a.time()));
            while (entries.size() > 50) {
                entries.remove(0);
            }
            JsonObject jsonObject = new JsonObject();
            JsonArray entryArray = new JsonArray();
            for (TransactionEntry entry : entries) {
                JsonObject entryJson = TransactionHistoryManager.toJson(entry);
                entryArray.add((JsonElement)entryJson);
            }
            jsonObject.add("entries", (JsonElement)entryArray);
            Files.write(savePath, gson.toJson((JsonElement)jsonObject).getBytes(), new OpenOption[0]);
        }
        catch (Exception e) {
            JCMLogger.error("Error saving transaction record to JSON file: {}", e.getMessage());
        }
    }

    public static List<TransactionEntry> getLogs(PlayerEntity player) {
        Path savePath = TransactionHistoryManager.getSavePath(player.getServer(), player.getUuidAsString());
        savePath.getParent().toFile().mkdirs();
        ArrayList<TransactionEntry> entries = new ArrayList<TransactionEntry>();
        try {
            if (Files.exists(savePath, new LinkOption[0])) {
                JsonObject jsonObject = jsonParser.parse(String.join((CharSequence)"", Files.readAllLines(savePath))).getAsJsonObject();
                JsonArray entryArray = jsonObject.getAsJsonArray("entries");
                for (JsonElement element : entryArray) {
                    entries.add(TransactionHistoryManager.fromJson(element.getAsJsonObject()));
                }
            }
        }
        catch (Exception e) {
            JCMLogger.error("Failed to read transaction record from JSON file!", e);
            TransactionHistoryManager.saveLogs(new ArrayList<TransactionEntry>(), player);
        }
        Collections.sort(entries, (a, b) -> (int)(b.time() - a.time()));
        return entries;
    }

    public static Path getSavePath(MinecraftServer server, String playerUuid) {
        Path saveDirectory = server.getSavePath(WorldSavePath.getRootMapped()).resolve("jsblock").resolve("player_data");
        saveDirectory.toFile().mkdirs();
        return saveDirectory.resolve(playerUuid + ".json");
    }

    private static TransactionEntry fromJson(JsonObject jsonObject) {
        return new TransactionEntry(jsonObject.get("source").getAsString(), jsonObject.get("amount").getAsInt(), jsonObject.get("time").getAsLong());
    }

    private static JsonObject toJson(TransactionEntry entry) {
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("source", entry.source());
        jsonObject.addProperty("amount", (Number)entry.amount());
        jsonObject.addProperty("time", (Number)entry.time());
        return jsonObject;
    }
}

