/*
 * Decompiled with CFR 0.152.
 */
package com.lx862.jcm.mod.block.base;

import com.lx862.jcm.mapping.LoaderImpl;
import com.lx862.jcm.mod.util.BlockUtil;
import java.util.function.BiConsumer;
import net.minecraft.class_2248;
import org.mtr.mapping.holder.BlockEntity;
import org.mtr.mapping.holder.BlockPos;
import org.mtr.mapping.holder.BlockSettings;
import org.mtr.mapping.holder.BlockState;
import org.mtr.mapping.holder.PlayerEntity;
import org.mtr.mapping.holder.World;
import org.mtr.mapping.holder.WorldAccess;
import org.mtr.mapping.mapper.BlockExtension;
import org.mtr.mapping.tool.HolderBase;

public abstract class JCMBlock
extends BlockExtension {
    public JCMBlock(BlockSettings settings) {
        super(LoaderImpl.getSolidBlockSettings(settings));
    }

    public void loopStructure(BlockState state, World world, BlockPos sourcePos, BiConsumer<BlockState, BlockEntity> callback) {
        for (BlockPos bPos : this.getAllPos(state, world, sourcePos)) {
            BlockState bs = world.getBlockState(sourcePos);
            BlockEntity be = BlockUtil.getBlockEntityOrNull(world, bPos);
            if (be == null) continue;
            callback.accept(bs, be);
        }
    }

    protected void breakWithoutDropIfCreative(World world, BlockPos pos, BlockState state, PlayerEntity player, BlockExtension blockInstance, GetLootDropPositionCallback getLootPos) {
        if (player.isCreative()) {
            BlockPos dropPos = getLootPos.get(state, pos);
            if (((class_2248)world.getBlockState((BlockPos)dropPos).getBlock().data).equals(blockInstance)) {
                world.breakBlock(dropPos, false);
            }
        }
    }

    public BlockPos[] getAllPos(BlockState state, WorldAccess world, BlockPos sourcePos) {
        return new BlockPos[]{sourcePos};
    }

    public BlockPos[] getAllPos(BlockState state, World world, BlockPos sourcePos) {
        return this.getAllPos(state, WorldAccess.cast((HolderBase)world), sourcePos);
    }

    @FunctionalInterface
    public static interface GetLootDropPositionCallback {
        public BlockPos get(BlockState var1, BlockPos var2);
    }
}

