/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.utils;

import java.util.Optional;
import mod.chiselsandbits.api.blockinformation.IBlockInformation;
import mod.chiselsandbits.api.item.bit.IBitItem;
import mod.chiselsandbits.api.item.click.ILeftClickControllingItem;
import mod.chiselsandbits.api.item.click.IRightClickControllingItem;
import mod.chiselsandbits.api.item.multistate.IMultiStateItem;
import mod.chiselsandbits.api.item.pattern.IPatternItem;
import mod.chiselsandbits.api.item.withhighlight.IWithHighlightItem;
import mod.chiselsandbits.api.item.withmode.IWithModeItem;
import mod.chiselsandbits.api.util.SingleBlockBlockReader;
import mod.chiselsandbits.api.variant.state.IStateVariantManager;
import mod.chiselsandbits.blockinformation.BlockInformation;
import net.minecraft.class_1268;
import net.minecraft.class_1657;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1922;
import net.minecraft.class_1935;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2302;
import net.minecraft.class_2338;
import net.minecraft.class_2344;
import net.minecraft.class_2358;
import net.minecraft.class_2362;
import net.minecraft.class_2369;
import net.minecraft.class_2404;
import net.minecraft.class_2680;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ItemStackUtils {
    private ItemStackUtils() {
        throw new IllegalStateException("Can not instantiate an instance of: ItemStackUtils. This is a utility class");
    }

    public static class_1799 getItemStackFromBlockState(@NotNull IBlockInformation blockInformation) {
        Optional<class_1799> dynamicStack = IStateVariantManager.getInstance().getItemStack(blockInformation);
        if (dynamicStack.isPresent()) {
            return dynamicStack.get();
        }
        class_2248 class_22482 = blockInformation.getBlockState().method_26204();
        if (class_22482 instanceof class_2404) {
            class_2404 liquidBlock = (class_2404)class_22482;
            return new class_1799((class_1935)liquidBlock.method_9545(blockInformation.getBlockState()).method_15772().method_15774());
        }
        class_1792 item = ItemStackUtils.getItem(blockInformation);
        if (item != class_1802.field_8162 && item != null) {
            return new class_1799((class_1935)item, 1);
        }
        return new class_1799((class_1935)blockInformation.getBlockState().method_26204(), 1);
    }

    public static class_1792 getItem(@NotNull IBlockInformation blockInformation) {
        class_2248 block = blockInformation.getBlockState().method_26204();
        if (block.equals(class_2246.field_10164)) {
            return class_1802.field_8187;
        }
        if (block instanceof class_2302) {
            class_1799 stack = block.method_9574((class_1922)new SingleBlockBlockReader(blockInformation), class_2338.field_10980, blockInformation.getBlockState());
            if (!stack.method_7960()) {
                return stack.method_7909();
            }
            return class_1802.field_8317;
        }
        if (block instanceof class_2344 || block instanceof class_2369) {
            return class_2246.field_10566.method_8389();
        }
        if (block instanceof class_2358) {
            return class_1802.field_8884;
        }
        if (block instanceof class_2362) {
            return class_1802.field_8074;
        }
        if (block == class_2246.field_10108) {
            return class_1802.field_8648;
        }
        return block.method_8389();
    }

    public static class_1799 getModeItemStackFromPlayer(@Nullable class_1657 playerEntity) {
        if (playerEntity == null) {
            return class_1799.field_8037;
        }
        if (playerEntity.method_6047().method_7909() instanceof IWithModeItem) {
            return playerEntity.method_6047();
        }
        if (playerEntity.method_6079().method_7909() instanceof IWithModeItem) {
            return playerEntity.method_6079();
        }
        return class_1799.field_8037;
    }

    public static class_1799 getHighlightItemStackFromPlayer(@Nullable class_1657 playerEntity) {
        if (playerEntity == null) {
            return class_1799.field_8037;
        }
        if (playerEntity.method_6047().method_7909() instanceof IWithHighlightItem) {
            return playerEntity.method_6047();
        }
        if (playerEntity.method_6079().method_7909() instanceof IWithHighlightItem) {
            return playerEntity.method_6079();
        }
        return class_1799.field_8037;
    }

    public static class_1799 getMultiStateItemStackFromPlayer(@Nullable class_1657 playerEntity) {
        if (playerEntity == null) {
            return class_1799.field_8037;
        }
        if (playerEntity.method_6047().method_7909() instanceof IMultiStateItem) {
            return playerEntity.method_6047();
        }
        if (playerEntity.method_6079().method_7909() instanceof IMultiStateItem) {
            return playerEntity.method_6079();
        }
        return class_1799.field_8037;
    }

    public static class_1799 getPatternItemStackFromPlayer(@Nullable class_1657 playerEntity) {
        if (playerEntity == null) {
            return class_1799.field_8037;
        }
        if (playerEntity.method_6047().method_7909() instanceof IPatternItem) {
            return playerEntity.method_6047();
        }
        if (playerEntity.method_6079().method_7909() instanceof IPatternItem) {
            return playerEntity.method_6079();
        }
        return class_1799.field_8037;
    }

    public static class_1268 getPatternHandFromPlayer(@Nullable class_1657 playerEntity) {
        if (playerEntity == null) {
            return class_1268.field_5808;
        }
        if (playerEntity.method_6079().method_7909() instanceof IPatternItem) {
            return class_1268.field_5810;
        }
        return class_1268.field_5808;
    }

    public static class_1799 getBitItemStackFromPlayer(@Nullable class_1657 playerEntity) {
        if (playerEntity == null) {
            return class_1799.field_8037;
        }
        if (playerEntity.method_6047().method_7909() instanceof IBitItem) {
            return playerEntity.method_6047();
        }
        if (playerEntity.method_6079().method_7909() instanceof IBitItem) {
            return playerEntity.method_6079();
        }
        return class_1799.field_8037;
    }

    public static class_1799 getLeftClickControllingItemStackFromPlayer(@Nullable class_1657 playerEntity) {
        if (playerEntity == null) {
            return class_1799.field_8037;
        }
        if (playerEntity.method_6047().method_7909() instanceof ILeftClickControllingItem) {
            return playerEntity.method_6047();
        }
        if (playerEntity.method_6079().method_7909() instanceof ILeftClickControllingItem) {
            return playerEntity.method_6079();
        }
        return class_1799.field_8037;
    }

    public static class_1799 getRightClickControllingItemStackFromPlayer(@Nullable class_1657 playerEntity) {
        if (playerEntity == null) {
            return class_1799.field_8037;
        }
        if (playerEntity.method_6047().method_7909() instanceof IRightClickControllingItem) {
            return playerEntity.method_6047();
        }
        if (playerEntity.method_6079().method_7909() instanceof IRightClickControllingItem) {
            return playerEntity.method_6079();
        }
        return class_1799.field_8037;
    }

    public static IBlockInformation getHeldBitBlockInformationFromPlayer(@Nullable class_1657 playerEntity) {
        if (playerEntity == null) {
            return BlockInformation.AIR;
        }
        if (playerEntity.method_6047().method_7909() instanceof IBitItem) {
            return ((IBitItem)playerEntity.method_6047().method_7909()).getBlockInformation(playerEntity.method_6047());
        }
        if (playerEntity.method_6079().method_7909() instanceof IBitItem) {
            return ((IBitItem)playerEntity.method_6079().method_7909()).getBlockInformation(playerEntity.method_6079());
        }
        return BlockInformation.AIR;
    }

    public static IBlockInformation getStateFromItem(class_1799 is) {
        try {
            class_1792 class_17922;
            if (!is.method_7960() && (class_17922 = is.method_7909()) instanceof class_1747) {
                class_1747 blockItem = (class_1747)class_17922;
                class_2680 blockState = blockItem.method_7711().method_9564();
                return new BlockInformation(blockState, IStateVariantManager.getInstance().getStateVariant(blockState, is));
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return BlockInformation.AIR;
    }
}

