/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.pattern.placement;

import com.communi.suggestu.scena.core.registries.AbstractCustomRegistryEntry;
import java.util.Optional;
import java.util.stream.Stream;
import mod.chiselsandbits.api.axissize.CollisionType;
import mod.chiselsandbits.api.blockinformation.IBlockInformation;
import mod.chiselsandbits.api.change.IChangeTrackerManager;
import mod.chiselsandbits.api.config.IClientConfiguration;
import mod.chiselsandbits.api.exceptions.SpaceOccupiedException;
import mod.chiselsandbits.api.inventory.bit.IBitInventory;
import mod.chiselsandbits.api.inventory.management.IBitInventoryManager;
import mod.chiselsandbits.api.item.withmode.group.IToolModeGroup;
import mod.chiselsandbits.api.multistate.accessor.IAreaAccessor;
import mod.chiselsandbits.api.multistate.mutator.IMutatorFactory;
import mod.chiselsandbits.api.multistate.mutator.world.IWorldAreaMutator;
import mod.chiselsandbits.api.multistate.snapshot.IMultiStateSnapshot;
import mod.chiselsandbits.api.pattern.placement.IPatternPlacementType;
import mod.chiselsandbits.api.placement.PlacementResult;
import mod.chiselsandbits.api.util.BlockPosStreamProvider;
import mod.chiselsandbits.api.util.IBatchMutation;
import mod.chiselsandbits.api.util.LocalStrings;
import mod.chiselsandbits.voxelshape.VoxelShapeManager;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1799;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_265;
import net.minecraft.class_2960;
import net.minecraft.class_3965;
import net.minecraft.class_4970;
import org.jetbrains.annotations.NotNull;

public class PlacePatternPlacementType
extends AbstractCustomRegistryEntry
implements IPatternPlacementType {
    @Override
    public class_265 buildVoxelShapeForWireframe(IMultiStateSnapshot sourceSnapshot, class_1657 player, class_243 targetedPoint, class_2350 hitFace) {
        return VoxelShapeManager.getInstance().get((IAreaAccessor)sourceSnapshot, CollisionType.NONE_AIR);
    }

    @Override
    public PlacementResult performPlacement(IMultiStateSnapshot source, class_1750 context, boolean simulate) {
        boolean hasRequiredBits;
        class_243 targetedPosition = context.method_8036().method_5715() ? context.method_17698() : class_243.method_24954((class_2382)context.method_8037());
        IWorldAreaMutator areaMutator = IMutatorFactory.getInstance().covering((class_1936)context.method_8045(), targetedPosition, targetedPosition.method_1031(0.9999, 0.9999, 0.9999));
        boolean isAir = BlockPosStreamProvider.getForAccessor(areaMutator).map(arg_0 -> ((class_1937)context.method_8045()).method_8320(arg_0)).allMatch(class_4970.class_4971::method_26215);
        if (!isAir) {
            return PlacementResult.failure(IClientConfiguration::getNotFittingPatternPlacementColor, (class_2561)LocalStrings.PatternPlacementNotAnAirBlock.getText());
        }
        IBitInventory playerBitInventory = IBitInventoryManager.getInstance().create(context.method_8036());
        boolean bl = hasRequiredBits = context.method_8036().method_7337() || source.getStatics().getStateCounts().entrySet().stream().filter(e -> !((IBlockInformation)e.getKey()).isAir()).allMatch(e -> playerBitInventory.canExtract((IBlockInformation)e.getKey(), (Integer)e.getValue()));
        if (!hasRequiredBits) {
            return PlacementResult.failure(IClientConfiguration::getMissingBitsOrSpacePatternPlacementColor, (class_2561)LocalStrings.PatternPlacementNotEnoughBits.getText());
        }
        if (simulate) {
            return PlacementResult.success();
        }
        try (IBatchMutation ignored = areaMutator.batch(IChangeTrackerManager.getInstance().getChangeTracker(context.method_8036()));){
            ((Stream)source.stream().sequential()).forEach(stateEntryInfo -> {
                try {
                    areaMutator.setInAreaTarget(stateEntryInfo.getBlockInformation(), stateEntryInfo.getStartPoint());
                }
                catch (SpaceOccupiedException spaceOccupiedException) {
                    // empty catch block
                }
            });
        }
        if (!context.method_8036().method_7337()) {
            source.getStatics().getStateCounts().entrySet().stream().filter(e -> !((IBlockInformation)e.getKey()).isAir()).forEach(e -> playerBitInventory.extract((IBlockInformation)e.getKey(), (Integer)e.getValue()));
        }
        return PlacementResult.success();
    }

    @Override
    public class_243 getTargetedPosition(class_1799 heldStack, class_1657 playerEntity, class_3965 blockRayTraceResult) {
        if (playerEntity.method_5715()) {
            return blockRayTraceResult.method_17784();
        }
        return class_243.method_24954((class_2382)blockRayTraceResult.method_17777().method_10081(blockRayTraceResult.method_17780().method_10163()));
    }

    @Override
    public boolean overridesOccupiedBits(class_1799 heldStack) {
        return false;
    }

    @Override
    @NotNull
    public class_2960 getIcon() {
        return new class_2960("chiselsandbits", "textures/icons/pattern_place.png");
    }

    @Override
    @NotNull
    public Optional<IToolModeGroup> getGroup() {
        return Optional.empty();
    }

    @Override
    public class_2561 getDisplayName() {
        return LocalStrings.PatternPlacementModePlacement.getText();
    }
}

