/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.multistate.snapshot;

import com.google.common.collect.Maps;
import java.util.Arrays;
import java.util.BitSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import mod.chiselsandbits.api.axissize.CollisionType;
import mod.chiselsandbits.api.block.storage.IStateEntryStorage;
import mod.chiselsandbits.api.blockinformation.IBlockInformation;
import mod.chiselsandbits.api.exceptions.SpaceOccupiedException;
import mod.chiselsandbits.api.item.multistate.IMultiStateItemStack;
import mod.chiselsandbits.api.multistate.StateEntrySize;
import mod.chiselsandbits.api.multistate.accessor.IStateEntryInfo;
import mod.chiselsandbits.api.multistate.accessor.identifier.IAreaShapeIdentifier;
import mod.chiselsandbits.api.multistate.accessor.identifier.IArrayBackedAreaShapeIdentifier;
import mod.chiselsandbits.api.multistate.accessor.sortable.IPositionMutator;
import mod.chiselsandbits.api.multistate.mutator.IMutableStateEntryInfo;
import mod.chiselsandbits.api.multistate.mutator.callback.StateClearer;
import mod.chiselsandbits.api.multistate.mutator.callback.StateSetter;
import mod.chiselsandbits.api.multistate.snapshot.IMultiStateSnapshot;
import mod.chiselsandbits.api.multistate.statistics.IMultiStateObjectStatistics;
import mod.chiselsandbits.api.util.BlockPosForEach;
import mod.chiselsandbits.api.util.BlockPosStreamProvider;
import mod.chiselsandbits.api.util.VectorUtils;
import mod.chiselsandbits.block.entities.storage.SimpleStateEntryStorage;
import mod.chiselsandbits.blockinformation.BlockInformation;
import mod.chiselsandbits.item.ChiseledBlockItem;
import mod.chiselsandbits.item.multistate.SingleBlockMultiStateItemStack;
import mod.chiselsandbits.registrars.ModItems;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import org.apache.commons.lang3.NotImplementedException;
import org.jetbrains.annotations.NotNull;

public class SimpleSnapshot
implements IMultiStateSnapshot {
    private final IStateEntryStorage chunkSection;
    private IMultiStateObjectStatistics stateObjectStatistics = null;

    public SimpleSnapshot() {
        this.chunkSection = new SimpleStateEntryStorage();
        this.chunkSection.initializeWith(BlockInformation.AIR);
    }

    public SimpleSnapshot(IBlockInformation blockInformation) {
        this.chunkSection = new SimpleStateEntryStorage();
        this.chunkSection.initializeWith(blockInformation);
    }

    public SimpleSnapshot(IStateEntryStorage chunkSection) {
        this.chunkSection = chunkSection;
    }

    @Override
    public IAreaShapeIdentifier createNewShapeIdentifier() {
        return new Identifier(this.chunkSection);
    }

    @Override
    public Stream<IStateEntryInfo> stream() {
        return BlockPosStreamProvider.getForRange(StateEntrySize.current().getBitsPerBlockSide()).map(blockPos -> new StateEntry(this.chunkSection.getBlockInformation(blockPos.method_10263(), blockPos.method_10264(), blockPos.method_10260()), (class_2382)blockPos, this::setInAreaTarget, this::clearInAreaTarget));
    }

    @Override
    public boolean isInside(class_243 inAreaTarget) {
        return !(inAreaTarget.method_10216() < 0.0 || inAreaTarget.method_10214() < 0.0 || inAreaTarget.method_10215() < 0.0 || inAreaTarget.method_10216() >= 1.0 || inAreaTarget.method_10214() >= 1.0 || inAreaTarget.method_10215() >= 1.0);
    }

    @Override
    public boolean isInside(class_2338 inAreaBlockPosOffset, class_243 inBlockTarget) {
        if (!inAreaBlockPosOffset.equals((Object)class_2338.field_10980)) {
            return false;
        }
        return this.isInside(inBlockTarget);
    }

    @Override
    public IMultiStateSnapshot createSnapshot() {
        return new SimpleSnapshot(this.chunkSection.createSnapshot());
    }

    @Override
    public Stream<IStateEntryInfo> streamWithPositionMutator(IPositionMutator positionMutator) {
        return BlockPosStreamProvider.getForRange(StateEntrySize.current().getBitsPerBlockSide()).map(positionMutator::mutate).map(blockPos -> new StateEntry(this.chunkSection.getBlockInformation(blockPos.method_10263(), blockPos.method_10264(), blockPos.method_10260()), (class_2382)blockPos, this::setInAreaTarget, this::clearInAreaTarget));
    }

    @Override
    public Optional<IStateEntryInfo> getInAreaTarget(class_243 inAreaTarget) {
        if (inAreaTarget.method_10216() < 0.0 || inAreaTarget.method_10214() < 0.0 || inAreaTarget.method_10215() < 0.0 || inAreaTarget.method_10216() >= 1.0 || inAreaTarget.method_10214() >= 1.0 || inAreaTarget.method_10215() >= 1.0) {
            throw new IllegalArgumentException("Target is not in the current area.");
        }
        class_2338 inAreaPos = VectorUtils.toBlockPos(inAreaTarget.method_18805((double)StateEntrySize.current().getBitsPerBlockSide(), (double)StateEntrySize.current().getBitsPerBlockSide(), (double)StateEntrySize.current().getBitsPerBlockSide()));
        IBlockInformation currentState = this.chunkSection.getBlockInformation(inAreaPos.method_10263(), inAreaPos.method_10264(), inAreaPos.method_10260());
        return currentState.isAir() ? Optional.empty() : Optional.of(new StateEntry(currentState, (class_2382)inAreaPos, this::setInAreaTarget, this::clearInAreaTarget));
    }

    @Override
    public void forEachWithPositionMutator(IPositionMutator positionMutator, Consumer<IStateEntryInfo> consumer) {
        BlockPosForEach.forEachInRange(StateEntrySize.current().getBitsPerBlockSide(), blockPos -> {
            class_2382 target = positionMutator.mutate((class_2382)blockPos);
            consumer.accept(new StateEntry(this.chunkSection.getBlockInformation(target.method_10263(), target.method_10264(), target.method_10260()), target, this::setInAreaTarget, this::clearInAreaTarget));
        });
    }

    @Override
    public Stream<IMutableStateEntryInfo> mutableStream() {
        return BlockPosStreamProvider.getForRange(StateEntrySize.current().getBitsPerBlockSide()).map(blockPos -> new StateEntry(this.chunkSection.getBlockInformation(blockPos.method_10263(), blockPos.method_10264(), blockPos.method_10260()), (class_2382)blockPos, this::setInAreaTarget, this::clearInAreaTarget));
    }

    @Override
    public void setInAreaTarget(IBlockInformation blockInformation, class_243 inAreaTarget) throws SpaceOccupiedException {
        if (inAreaTarget.method_10216() < 0.0 || inAreaTarget.method_10214() < 0.0 || inAreaTarget.method_10215() < 0.0 || inAreaTarget.method_10216() >= 1.0 || inAreaTarget.method_10214() >= 1.0 || inAreaTarget.method_10215() >= 1.0) {
            throw new IllegalArgumentException("Target is not in the current area.");
        }
        class_2338 inAreaPos = VectorUtils.toBlockPos(inAreaTarget.method_18805((double)StateEntrySize.current().getBitsPerBlockSide(), (double)StateEntrySize.current().getBitsPerBlockSide(), (double)StateEntrySize.current().getBitsPerBlockSide()));
        IBlockInformation currentState = this.chunkSection.getBlockInformation(inAreaPos.method_10263(), inAreaPos.method_10264(), inAreaPos.method_10260());
        if (!currentState.isAir()) {
            throw new SpaceOccupiedException();
        }
        this.chunkSection.setBlockInformation(inAreaPos.method_10263(), inAreaPos.method_10264(), inAreaPos.method_10260(), blockInformation);
    }

    @Override
    public Optional<IStateEntryInfo> getInBlockTarget(class_2338 inAreaBlockPosOffset, class_243 inBlockTarget) {
        if (!inAreaBlockPosOffset.equals((Object)class_2338.field_10980)) {
            throw new IllegalStateException(String.format("The given in area block pos offset is not inside the current block: %s", inAreaBlockPosOffset));
        }
        return this.getInAreaTarget(inBlockTarget);
    }

    @Override
    public void setInBlockTarget(IBlockInformation blockInformation, class_2338 inAreaBlockPosOffset, class_243 inBlockTarget) throws SpaceOccupiedException {
        if (!inAreaBlockPosOffset.equals((Object)class_2338.field_10980)) {
            throw new IllegalStateException(String.format("The given in area block pos offset is not inside the current block: %s", inAreaBlockPosOffset));
        }
        this.setInAreaTarget(blockInformation, inBlockTarget);
    }

    @Override
    public void clearInAreaTarget(class_243 inAreaTarget) {
        if (inAreaTarget.method_10216() < 0.0 || inAreaTarget.method_10214() < 0.0 || inAreaTarget.method_10215() < 0.0 || inAreaTarget.method_10216() >= 1.0 || inAreaTarget.method_10214() >= 1.0 || inAreaTarget.method_10215() >= 1.0) {
            throw new IllegalArgumentException("Target is not in the current area.");
        }
        class_2338 inAreaPos = VectorUtils.toBlockPos(inAreaTarget.method_18805((double)StateEntrySize.current().getBitsPerBlockSide(), (double)StateEntrySize.current().getBitsPerBlockSide(), (double)StateEntrySize.current().getBitsPerBlockSide()));
        IBlockInformation blockState = BlockInformation.AIR;
        this.chunkSection.setBlockInformation(inAreaPos.method_10263(), inAreaPos.method_10264(), inAreaPos.method_10260(), blockState);
    }

    @Override
    public void clearInBlockTarget(class_2338 inAreaBlockPosOffset, class_243 inBlockTarget) {
        if (!inAreaBlockPosOffset.equals((Object)class_2338.field_10980)) {
            throw new IllegalStateException(String.format("The given in area block pos offset is not inside the current block: %s", inAreaBlockPosOffset));
        }
        this.clearInAreaTarget(inBlockTarget);
    }

    @Override
    public IMultiStateItemStack toItemStack() {
        IBlockInformation primaryState = this.determinePrimaryState();
        ChiseledBlockItem chiseledBlockItem = (ChiseledBlockItem)ModItems.CHISELED_BLOCK.get();
        return new SingleBlockMultiStateItemStack((class_1792)chiseledBlockItem, this.chunkSection.createSnapshot());
    }

    @Override
    public IMultiStateObjectStatistics getStatics() {
        this.buildStatistics();
        return this.stateObjectStatistics;
    }

    private void buildStatistics() {
        this.stateObjectStatistics = new IMultiStateObjectStatistics(){

            @Override
            public class_2487 serializeNBT() {
                return new class_2487();
            }

            @Override
            public void deserializeNBT(class_2487 nbt) {
            }

            @Override
            public IBlockInformation getPrimaryState() {
                return SimpleSnapshot.this.determinePrimaryState();
            }

            @Override
            public Map<IBlockInformation, Integer> getStateCounts() {
                return SimpleSnapshot.this.stream().collect(Collectors.toMap(IStateEntryInfo::getBlockInformation, s -> 1, Integer::sum));
            }

            @Override
            public boolean shouldCheckWeakPower() {
                throw new NotImplementedException("Is a snapshot");
            }

            @Override
            public float getFullnessFactor() {
                throw new NotImplementedException("Is a snapshot");
            }

            @Override
            public float getSlipperiness() {
                throw new NotImplementedException("Is a snapshot");
            }

            @Override
            public float getLightEmissionFactor() {
                throw new NotImplementedException("Is a snapshot");
            }

            @Override
            public float getLightBlockingFactor() {
                throw new NotImplementedException("Is a snapshot");
            }

            @Override
            public float getRelativeBlockHardness(class_1657 player) {
                throw new NotImplementedException("Is a snapshot");
            }

            @Override
            public boolean canPropagateSkylight() {
                throw new NotImplementedException("Is a snapshot");
            }

            @Override
            public boolean canSustainGrassBelow() {
                throw new NotImplementedException("Is a snapshot");
            }

            @Override
            public BitSet getCollideableEntries(CollisionType collisionType) {
                return BitSet.valueOf(new long[0]);
            }

            @Override
            public boolean isEmpty() {
                return !SimpleSnapshot.this.determinePrimaryState().isAir();
            }
        };
    }

    private IBlockInformation determinePrimaryState() {
        HashMap countMap = Maps.newHashMap();
        this.chunkSection.count(countMap::put);
        IBlockInformation maxState = BlockInformation.AIR;
        int maxCount = 0;
        for (Map.Entry blockStateIntegerEntry : countMap.entrySet()) {
            if (maxCount >= (Integer)blockStateIntegerEntry.getValue() || ((IBlockInformation)blockStateIntegerEntry.getKey()).isAir()) continue;
            maxState = (IBlockInformation)blockStateIntegerEntry.getKey();
            maxCount = (Integer)blockStateIntegerEntry.getValue();
        }
        return maxState;
    }

    @Override
    public void rotate(class_2350.class_2351 axis, int rotationCount) {
        this.chunkSection.rotate(axis, rotationCount);
        this.buildStatistics();
    }

    @Override
    public void mirror(class_2350.class_2351 axis) {
        this.chunkSection.mirror(axis);
        this.buildStatistics();
    }

    @Override
    public IMultiStateSnapshot clone() {
        return new SimpleSnapshot(this.chunkSection.createSnapshot());
    }

    @Override
    @NotNull
    public class_238 getBoundingBox() {
        return new class_238(0.0, 0.0, 0.0, 1.0, 1.0, 1.0);
    }

    private static class Identifier
    implements IArrayBackedAreaShapeIdentifier {
        private final IStateEntryStorage snapshot;

        private Identifier(IStateEntryStorage section) {
            this.snapshot = section.createSnapshot();
        }

        public int hashCode() {
            return this.snapshot.hashCode();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof IArrayBackedAreaShapeIdentifier)) {
                return false;
            }
            IArrayBackedAreaShapeIdentifier that = (IArrayBackedAreaShapeIdentifier)o;
            return Arrays.equals(this.getBackingData(), that.getBackingData()) && that.getPalette().equals(this.getPalette());
        }

        @Override
        public byte[] getBackingData() {
            return this.snapshot.getRawData();
        }

        @Override
        public List<IBlockInformation> getPalette() {
            return this.snapshot.getContainedPalette();
        }
    }

    private static class StateEntry
    implements IMutableStateEntryInfo {
        private final IBlockInformation blockInformation;
        private final class_243 startPoint;
        private final class_243 endPoint;
        private final StateSetter stateSetter;
        private final StateClearer stateClearer;

        private StateEntry(IBlockInformation blockInformation, class_2382 startPoint, StateSetter stateSetter, StateClearer stateClearer) {
            this.blockInformation = blockInformation;
            this.startPoint = class_243.method_24954((class_2382)startPoint).method_18805((double)StateEntrySize.current().getSizePerBit(), (double)StateEntrySize.current().getSizePerBit(), (double)StateEntrySize.current().getSizePerBit());
            this.endPoint = class_243.method_24954((class_2382)startPoint).method_18805((double)StateEntrySize.current().getSizePerBit(), (double)StateEntrySize.current().getSizePerBit(), (double)StateEntrySize.current().getSizePerBit()).method_1031((double)StateEntrySize.current().getSizePerBit(), (double)StateEntrySize.current().getSizePerBit(), (double)StateEntrySize.current().getSizePerBit());
            this.stateSetter = stateSetter;
            this.stateClearer = stateClearer;
        }

        @Override
        @NotNull
        public IBlockInformation getBlockInformation() {
            return this.blockInformation;
        }

        @Override
        @NotNull
        public class_243 getStartPoint() {
            return this.startPoint;
        }

        @Override
        @NotNull
        public class_243 getEndPoint() {
            return this.endPoint;
        }

        @Override
        public void setBlockInformation(IBlockInformation blockInformation) throws SpaceOccupiedException {
            this.stateSetter.set(blockInformation, this.getStartPoint());
        }

        @Override
        public void clear() {
            this.stateClearer.accept(this.getStartPoint());
        }
    }
}

