/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.item.bit;

import com.communi.suggestu.scena.core.dist.Dist;
import com.communi.suggestu.scena.core.dist.DistExecutor;
import com.communi.suggestu.scena.core.fluid.IFluidManager;
import com.communi.suggestu.scena.core.registries.ICustomRegistryEntry;
import com.communi.suggestu.scena.core.registries.IPlatformRegistryManager;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import mod.chiselsandbits.api.blockinformation.IBlockInformation;
import mod.chiselsandbits.api.chiseling.ChiselingOperation;
import mod.chiselsandbits.api.chiseling.IChiselingContext;
import mod.chiselsandbits.api.chiseling.IChiselingManager;
import mod.chiselsandbits.api.chiseling.ILocalChiselingContextCache;
import mod.chiselsandbits.api.chiseling.mode.IChiselMode;
import mod.chiselsandbits.api.client.render.preview.chiseling.IChiselContextPreviewRendererRegistry;
import mod.chiselsandbits.api.client.variant.state.IClientStateVariantManager;
import mod.chiselsandbits.api.config.IClientConfiguration;
import mod.chiselsandbits.api.item.bit.IBitItem;
import mod.chiselsandbits.api.item.chisel.IChiselingItem;
import mod.chiselsandbits.api.item.click.ClickProcessingState;
import mod.chiselsandbits.api.item.documentation.IDocumentableItem;
import mod.chiselsandbits.api.item.withmode.group.IToolModeGroup;
import mod.chiselsandbits.api.notifications.INotificationManager;
import mod.chiselsandbits.api.util.LocalStrings;
import mod.chiselsandbits.api.variant.state.IStateVariantManager;
import mod.chiselsandbits.blockinformation.BlockInformation;
import mod.chiselsandbits.chiseling.ChiselingManager;
import mod.chiselsandbits.client.render.ModRenderTypes;
import mod.chiselsandbits.registrars.ModCreativeTabs;
import mod.chiselsandbits.utils.ItemStackUtils;
import mod.chiselsandbits.utils.TranslationUtils;
import net.minecraft.class_1268;
import net.minecraft.class_1657;
import net.minecraft.class_1761;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2404;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_761;
import net.minecraft.class_7699;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BitItem
extends class_1792
implements IChiselingItem,
IBitItem,
IDocumentableItem {
    private static final Logger LOGGER = LogManager.getLogger();
    private final List<class_1799> availableBitStacks = Lists.newLinkedList();
    private final ThreadLocal<Boolean> threadLocalBitMergeOperationInProgress = ThreadLocal.withInitial(() -> false);

    public BitItem(class_1792.class_1793 properties) {
        super(properties);
    }

    @Override
    public ClickProcessingState handleLeftClickProcessing(class_1657 playerEntity, class_1268 hand, class_2338 position, class_2350 face, ClickProcessingState currentState) {
        return this.handleClickProcessing(playerEntity, hand, currentState, ChiselingOperation.CHISELING, IChiselMode::onLeftClickBy);
    }

    @Override
    public void onLeftClickProcessingEnd(class_1657 player, class_1799 stack) {
        IChiselMode chiselMode = this.getMode(stack);
        Optional<IChiselingContext> context = IChiselingManager.getInstance().get(player, chiselMode, ChiselingOperation.CHISELING);
        if (context.isEmpty()) {
            context = ILocalChiselingContextCache.getInstance().get(ChiselingOperation.CHISELING);
        }
        context.ifPresent(c -> {
            chiselMode.onStoppedLeftClicking(player, (IChiselingContext)c);
            if (c.isComplete()) {
                player.method_7357().method_7906((class_1792)this, 3);
                ILocalChiselingContextCache.getInstance().clear(ChiselingOperation.CHISELING);
            }
        });
    }

    @Override
    public boolean canUse(class_1657 playerEntity, class_1799 stack) {
        boolean isAllowedToUse;
        boolean bl = isAllowedToUse = ChiselingManager.getInstance().canChisel(playerEntity) && !playerEntity.method_7357().method_7904(stack.method_7909());
        if (this.getMode(stack).isSingleClickUse() && !isAllowedToUse && playerEntity.method_37908().method_8608() && IClientConfiguration.getInstance().getShowCoolDownError().get().booleanValue()) {
            INotificationManager.getInstance().notify(this.getMode(stack).getIcon(), new class_243(1.0, 0.0, 0.0), (class_2561)LocalStrings.ChiselAttemptFailedWaitForCoolDown.getText());
        }
        return isAllowedToUse;
    }

    @Override
    @NotNull
    public IChiselMode getMode(class_1799 stack) {
        class_2487 stackNbt = stack.method_7948();
        if (stackNbt.method_10545("chiselMode")) {
            String chiselModeName = stackNbt.method_10558("chiselMode");
            try {
                Optional registryMode = IChiselMode.getRegistry().get(new class_2960(chiselModeName));
                return registryMode.orElseGet(IChiselMode::getDefaultMode);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                LOGGER.error(String.format("An ItemStack got loaded with a name that is not a valid chisel mode: %s", chiselModeName));
                this.setMode(stack, IChiselMode.getDefaultMode());
            }
        }
        return IChiselMode.getDefaultMode();
    }

    @NotNull
    public class_2561 method_7864(@NotNull class_1799 stack) {
        IBlockInformation containedStack = this.getBlockInformation(stack);
        class_2248 block = containedStack.getBlockState().method_26204();
        class_2561 stateName = block.method_8389().method_7864(new class_1799((class_1935)block));
        if (block instanceof class_2404) {
            class_2404 flowingFluidBlock = (class_2404)block;
            stateName = IFluidManager.getInstance().getDisplayName(flowingFluidBlock.method_9545(flowingFluidBlock.method_9564()).method_15772());
        }
        if (containedStack.getVariant().isPresent()) {
            stateName = IStateVariantManager.getInstance().getName(containedStack).orElse(stateName);
        }
        return class_2561.method_43469((String)this.method_7866(stack), (Object[])new Object[]{stateName});
    }

    public void method_7851(@NotNull class_1799 stack, @Nullable class_1937 worldIn, @NotNull List<class_2561> tooltip, @NotNull class_1836 flagIn) {
        IChiselMode mode = this.getMode(stack);
        if (mode.getGroup().isPresent()) {
            tooltip.add((class_2561)TranslationUtils.build("chiselmode.mode_grouped", ((IToolModeGroup)mode.getGroup().get()).getDisplayName(), mode.getDisplayName()));
        } else {
            tooltip.add((class_2561)TranslationUtils.build("chiselmode.mode", mode.getDisplayName()));
        }
        IBlockInformation blockInformation = this.getBlockInformation(stack);
        DistExecutor.runWhenOn((Dist)Dist.CLIENT, () -> () -> IClientStateVariantManager.getInstance().appendHoverText(blockInformation, worldIn, tooltip, flagIn));
        super.method_7851(stack, worldIn, tooltip, flagIn);
    }

    @Override
    public void setMode(class_1799 stack, IChiselMode mode) {
        if (mode == null) {
            return;
        }
        stack.method_7948().method_10582("chiselMode", Objects.requireNonNull(mode.getRegistryName()).toString());
    }

    @Override
    @NotNull
    public Collection<IChiselMode> getPossibleModes() {
        return IChiselMode.getRegistry().getValues().stream().sorted(Comparator.comparing(ICustomRegistryEntry::getRegistryName)).collect(Collectors.toList());
    }

    @Override
    public ClickProcessingState handleRightClickProcessing(class_1657 playerEntity, class_1268 hand, class_2338 position, class_2350 face, ClickProcessingState currentState) {
        return this.handleClickProcessing(playerEntity, hand, currentState, ChiselingOperation.PLACING, IChiselMode::onRightClickBy);
    }

    @Override
    public void onRightClickProcessingEnd(class_1657 player, class_1799 stack) {
        IChiselMode chiselMode = this.getMode(stack);
        Optional<IChiselingContext> context = IChiselingManager.getInstance().get(player, chiselMode, ChiselingOperation.PLACING);
        if (context.isEmpty()) {
            context = ILocalChiselingContextCache.getInstance().get(ChiselingOperation.PLACING);
        }
        context.ifPresent(c -> {
            chiselMode.onStoppedRightClicking(player, (IChiselingContext)c);
            if (c.isComplete()) {
                player.method_7357().method_7906((class_1792)this, 3);
                ILocalChiselingContextCache.getInstance().clear(ChiselingOperation.PLACING);
            }
        });
    }

    private ClickProcessingState handleClickProcessing(class_1657 playerEntity, class_1268 hand, ClickProcessingState currentState, ChiselingOperation modeOfOperation, ChiselModeInteractionCallback callback) {
        class_1799 itemStack = playerEntity.method_5998(hand);
        if (itemStack.method_7960() || itemStack.method_7909() != this) {
            return currentState;
        }
        IChiselingItem chiselingItem = (IChiselingItem)itemStack.method_7909();
        IChiselMode chiselMode = (IChiselMode)chiselingItem.getMode(itemStack);
        IChiselingContext context = IChiselingManager.getInstance().getOrCreateContext(playerEntity, chiselMode, modeOfOperation, false, itemStack);
        ClickProcessingState resultState = callback.run(chiselMode, playerEntity, context);
        if (context.isComplete()) {
            playerEntity.method_7357().method_7906((class_1792)this, 3);
            ILocalChiselingContextCache.getInstance().clear(modeOfOperation);
        }
        if (context.getError().isPresent() && context.getWorld().method_8608()) {
            INotificationManager.getInstance().notify(context.getMode().getIcon(), new class_243(1.0, 0.0, 0.0), (class_2561)context.getError().get());
        }
        return resultState;
    }

    @Override
    @NotNull
    public IBlockInformation getBlockInformation(class_1799 stack) {
        if (!stack.method_7985()) {
            return BlockInformation.AIR;
        }
        return new BlockInformation(stack.method_7948().method_10562("block_information"));
    }

    @Override
    public void onMergeOperationWithBagBeginning() {
        this.threadLocalBitMergeOperationInProgress.set(true);
    }

    @Override
    public void onMergeOperationWithBagEnding() {
        this.threadLocalBitMergeOperationInProgress.set(false);
    }

    @Override
    public boolean shouldDrawDefaultHighlight(@NotNull class_1657 playerEntity) {
        class_1799 itemStack = ItemStackUtils.getHighlightItemStackFromPlayer(playerEntity);
        if (itemStack.method_7960() || itemStack.method_7909() != this) {
            return true;
        }
        IChiselingItem chiselingItem = (IChiselingItem)itemStack.method_7909();
        IChiselMode chiselMode = (IChiselMode)chiselingItem.getMode(itemStack);
        Optional<IChiselingContext> potentiallyExistingContext = IChiselingManager.getInstance().get(playerEntity, chiselMode, ChiselingOperation.CHISELING);
        if (potentiallyExistingContext.isPresent()) {
            IChiselingContext context = potentiallyExistingContext.get();
            if (context.getMutator().isPresent()) {
                return false;
            }
            IChiselingContext currentContextSnapshot = context.createSnapshot();
            if (currentContextSnapshot.getModeOfOperandus() == ChiselingOperation.CHISELING) {
                chiselMode.onLeftClickBy(playerEntity, currentContextSnapshot);
            } else {
                chiselMode.onRightClickBy(playerEntity, currentContextSnapshot);
            }
            return currentContextSnapshot.getMutator().isEmpty();
        }
        Optional<IChiselingContext> localCachedContext = ILocalChiselingContextCache.getInstance().get(ChiselingOperation.CHISELING);
        if (localCachedContext.isPresent()) {
            IChiselingContext context = localCachedContext.get();
            if (context.getMode() == chiselMode && context.getMutator().isPresent()) {
                return false;
            }
            return context.getMutator().isEmpty();
        }
        IChiselingContext context = IChiselingManager.getInstance().create(playerEntity, chiselMode, ChiselingOperation.CHISELING, true, itemStack);
        chiselMode.onLeftClickBy(playerEntity, context);
        if (context.getMutator().isPresent()) {
            return false;
        }
        chiselMode.onRightClickBy(playerEntity, context);
        return context.getMutator().isEmpty();
    }

    @Override
    public void renderHighlight(class_1657 playerEntity, class_761 worldRenderer, class_4587 matrixStack, float partialTicks) {
        class_1799 itemStack = ItemStackUtils.getHighlightItemStackFromPlayer(playerEntity);
        if (itemStack.method_7960() || itemStack.method_7909() != this) {
            return;
        }
        IChiselingItem chiselingItem = (IChiselingItem)itemStack.method_7909();
        IChiselMode chiselMode = (IChiselMode)chiselingItem.getMode(itemStack);
        Optional<IChiselingContext> potentiallyExistingContext = IChiselingManager.getInstance().get(playerEntity, chiselMode);
        Optional<IChiselingContext> potentialChiselingContext = ILocalChiselingContextCache.getInstance().get(ChiselingOperation.CHISELING);
        Optional<IChiselingContext> potentialPlacingContext = ILocalChiselingContextCache.getInstance().get(ChiselingOperation.PLACING);
        if (potentiallyExistingContext.isPresent()) {
            IChiselingContext currentContextSnapshot = potentiallyExistingContext.get().createSnapshot();
            if (currentContextSnapshot.getModeOfOperandus() == ChiselingOperation.CHISELING) {
                chiselMode.onLeftClickBy(playerEntity, currentContextSnapshot);
            } else {
                chiselMode.onRightClickBy(playerEntity, currentContextSnapshot);
            }
            IChiselContextPreviewRendererRegistry.getInstance().getCurrent().renderExistingContextsBoundingBox(matrixStack, currentContextSnapshot);
            return;
        }
        if (potentialChiselingContext.isPresent()) {
            IChiselingContext chiselingContext = potentialChiselingContext.get();
            if (potentialChiselingContext.get().getMode() == chiselMode && chiselingContext.getMode().isStillValid(playerEntity, chiselingContext, ChiselingOperation.CHISELING)) {
                IChiselContextPreviewRendererRegistry.getInstance().getCurrent().renderExistingContextsBoundingBox(matrixStack, chiselingContext);
            } else {
                ILocalChiselingContextCache.getInstance().clear(ChiselingOperation.CHISELING);
            }
            if (potentialPlacingContext.isPresent()) {
                IChiselingContext placingContext = potentialPlacingContext.get();
                if (placingContext.getMode() == chiselMode && potentialPlacingContext.get().getMode().isStillValid(playerEntity, potentialPlacingContext.get(), ChiselingOperation.PLACING)) {
                    IChiselContextPreviewRendererRegistry.getInstance().getCurrent().renderExistingContextsBoundingBox(matrixStack, placingContext);
                } else {
                    ILocalChiselingContextCache.getInstance().clear(ChiselingOperation.PLACING);
                }
            }
            return;
        }
        if (potentialPlacingContext.isPresent() && potentialPlacingContext.get().getMode() == chiselMode && chiselMode.isStillValid(playerEntity, potentialPlacingContext.get(), ChiselingOperation.PLACING)) {
            IChiselingContext context = potentialPlacingContext.get();
            IChiselContextPreviewRendererRegistry.getInstance().getCurrent().renderExistingContextsBoundingBox(matrixStack, context);
            return;
        }
        IChiselingContext chiselingContext = IChiselingManager.getInstance().create(playerEntity, chiselMode, ChiselingOperation.CHISELING, true, itemStack);
        IChiselingContext placingContext = IChiselingManager.getInstance().create(playerEntity, chiselMode, ChiselingOperation.PLACING, true, itemStack);
        chiselMode.onLeftClickBy(playerEntity, chiselingContext);
        chiselMode.onRightClickBy(playerEntity, placingContext);
        if (chiselingContext.getMutator().isPresent() && chiselingContext.getError().isEmpty()) {
            IChiselContextPreviewRendererRegistry.getInstance().getCurrent().renderExistingContextsBoundingBox(matrixStack, chiselingContext);
            ILocalChiselingContextCache.getInstance().set(ChiselingOperation.CHISELING, chiselingContext);
        }
        if (placingContext.getMutator().isPresent() && placingContext.getError().isEmpty()) {
            IChiselContextPreviewRendererRegistry.getInstance().getCurrent().renderExistingContextsBoundingBox(matrixStack, placingContext);
            ILocalChiselingContextCache.getInstance().set(ChiselingOperation.PLACING, placingContext);
        }
        class_310.method_1551().method_22940().method_23000().method_22994(ModRenderTypes.MEASUREMENT_LINES.get());
    }

    @Override
    public boolean isDamageableDuringChiseling() {
        return false;
    }

    @Override
    public Map<String, class_1799> getDocumentableInstances(class_1792 item) {
        this.ensureAvailableBitStacksAreLoaded();
        return this.availableBitStacks.stream().filter(stack -> !stack.method_7960()).collect(Collectors.toMap(stack -> "bit_" + IPlatformRegistryManager.getInstance().getBlockRegistry().getKey((Object)this.getBlockInformation((class_1799)stack).getBlockState().method_26204()).toString().replace(":", "_"), Function.identity()));
    }

    private void ensureAvailableBitStacksAreLoaded() {
        if (this.availableBitStacks.isEmpty()) {
            ((class_1761)ModCreativeTabs.BITS.get()).method_47306(new class_1761.class_8128(class_7699.method_45397(), false, null));
            this.availableBitStacks.addAll(((class_1761)ModCreativeTabs.BITS.get()).method_47313());
            this.availableBitStacks.sort(Comparator.comparing(stack -> {
                if (!(stack.method_7909() instanceof IBitItem)) {
                    throw new IllegalStateException("Stack did not contain a bit item.");
                }
                return ((IBitItem)stack.method_7909()).getBlockInformation((class_1799)stack);
            }));
        }
    }

    @FunctionalInterface
    private static interface ChiselModeInteractionCallback {
        public ClickProcessingState run(IChiselMode var1, class_1657 var2, IChiselingContext var3);
    }
}

