/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.item;

import com.communi.suggestu.scena.core.registries.ICustomRegistryEntry;
import java.util.Collection;
import java.util.Comparator;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import mod.chiselsandbits.api.block.entity.IMultiStateBlockEntity;
import mod.chiselsandbits.api.change.IChangeTrackerManager;
import mod.chiselsandbits.api.item.click.ClickProcessingState;
import mod.chiselsandbits.api.item.click.IRightClickControllingItem;
import mod.chiselsandbits.api.item.withmode.IWithModeItem;
import mod.chiselsandbits.api.modification.operation.IModificationOperation;
import mod.chiselsandbits.api.util.IBatchMutation;
import mod.chiselsandbits.api.util.RayTracingUtils;
import net.minecraft.class_1268;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_239;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2960;
import net.minecraft.class_3965;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class WrenchItem
extends class_1792
implements IWithModeItem<IModificationOperation>,
IRightClickControllingItem {
    private static final Logger LOGGER = LogManager.getLogger();

    public WrenchItem(class_1792.class_1793 properties) {
        super(properties);
    }

    @Override
    @NotNull
    public IModificationOperation getMode(class_1799 stack) {
        class_2487 stackNbt = stack.method_7948();
        if (stackNbt.method_10545("modificationMode")) {
            String modeName = stackNbt.method_10558("modificationMode");
            try {
                Optional registryMode = IModificationOperation.getRegistry().get(new class_2960(modeName));
                return registryMode.orElseGet(IModificationOperation::getDefaultMode);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                LOGGER.error(String.format("An ItemStack got loaded with a name that is not a valid modification mode: %s", modeName));
                this.setMode(stack, IModificationOperation.getDefaultMode());
            }
        }
        return IModificationOperation.getDefaultMode();
    }

    @Override
    public void setMode(class_1799 stack, IModificationOperation mode) {
        if (mode == null) {
            return;
        }
        stack.method_7948().method_10582("modificationMode", Objects.requireNonNull(mode.getRegistryName()).toString());
    }

    @Override
    @NotNull
    public Collection<IModificationOperation> getPossibleModes() {
        return IModificationOperation.getRegistry().getValues().stream().sorted(Comparator.comparing(ICustomRegistryEntry::getRegistryName)).collect(Collectors.toList());
    }

    @Override
    public boolean canUse(class_1657 playerEntity, class_1799 stack) {
        class_3965 blockHitResult;
        block3: {
            block2: {
                class_239 result = RayTracingUtils.rayTracePlayer(playerEntity);
                if (!(result instanceof class_3965)) break block2;
                blockHitResult = (class_3965)result;
                if (result.method_17783() == class_239.class_240.field_1332) break block3;
            }
            return false;
        }
        class_2586 blockEntity = playerEntity.method_37908().method_8321(blockHitResult.method_17777());
        return blockEntity instanceof IMultiStateBlockEntity;
    }

    @Override
    public ClickProcessingState handleRightClickProcessing(class_1657 playerEntity, class_1268 hand, class_2338 position, class_2350 face, ClickProcessingState currentState) {
        class_3965 blockHitResult;
        block12: {
            block11: {
                class_239 result = RayTracingUtils.rayTracePlayer(playerEntity);
                if (!(result instanceof class_3965)) break block11;
                blockHitResult = (class_3965)result;
                if (result.method_17783() == class_239.class_240.field_1332) break block12;
            }
            return ClickProcessingState.DENIED;
        }
        class_2586 blockEntity = playerEntity.method_37908().method_8321(blockHitResult.method_17777());
        if (!(blockEntity instanceof IMultiStateBlockEntity)) {
            return ClickProcessingState.DENIED;
        }
        IMultiStateBlockEntity multiStateBlockEntity = (IMultiStateBlockEntity)blockEntity;
        try (IBatchMutation ignored = multiStateBlockEntity.batch(IChangeTrackerManager.getInstance().getChangeTracker(playerEntity));){
            this.getMode(playerEntity.method_5998(hand)).apply(multiStateBlockEntity);
        }
        return ClickProcessingState.ALLOW;
    }

    @Override
    public void onRightClickProcessingEnd(class_1657 player, class_1799 stack) {
    }
}

