/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.inventory.bit;

import com.google.common.collect.Maps;
import it.unimi.dsi.fastutil.ints.Int2ObjectArrayMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.Collection;
import java.util.Map;
import java.util.UUID;
import mod.chiselsandbits.api.blockinformation.IBlockInformation;
import mod.chiselsandbits.api.inventory.bit.watchable.IWatch;
import mod.chiselsandbits.api.inventory.bit.watchable.IWatchableBitInventory;
import mod.chiselsandbits.api.item.bit.IBitItem;
import mod.chiselsandbits.api.item.bit.IBitItemManager;
import mod.chiselsandbits.api.util.INBTSerializable;
import mod.chiselsandbits.api.util.IPacketBufferSerializable;
import mod.chiselsandbits.blockinformation.BlockInformation;
import mod.chiselsandbits.inventory.bit.AbstractBitInventory;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import org.jetbrains.annotations.NotNull;

public class SlottedBitInventory
extends AbstractBitInventory
implements IWatchableBitInventory,
INBTSerializable<class_2487> {
    protected final int size;
    protected final Int2ObjectMap<BitSlot> slotMap = new Int2ObjectArrayMap();
    private final Map<UUID, Runnable> onChangeCallbacks = Maps.newConcurrentMap();

    public SlottedBitInventory(int size) {
        this.size = size;
    }

    @Override
    protected class_1799 method_5438(int index) {
        BitSlot bitSlot = (BitSlot)this.slotMap.get(index);
        if (bitSlot == null) {
            return class_1799.field_8037;
        }
        return bitSlot.internalStack;
    }

    @Override
    protected int getInventorySize() {
        return this.size;
    }

    @Override
    protected void setSlotContents(int index, class_1799 stack) {
        if (stack.method_7960()) {
            this.slotMap.remove(index);
            this.onChange();
            return;
        }
        class_1792 class_17922 = stack.method_7909();
        if (!(class_17922 instanceof IBitItem)) {
            throw new IllegalArgumentException("Can not insert a none bit item into the inventory.");
        }
        IBitItem bitItem = (IBitItem)class_17922;
        IBlockInformation state = bitItem.getBlockInformation(stack);
        BitSlot slot = (BitSlot)this.slotMap.get(index);
        if (slot == null) {
            slot = new BitSlot();
        }
        slot.setBlockInformation(state);
        slot.setCount(stack.method_7947());
        if (!this.slotMap.containsKey(index)) {
            this.slotMap.put(index, (Object)slot);
        }
        this.onChange();
    }

    @Override
    public IWatch startWatching(Runnable onChangeCallback) {
        UUID id = UUID.randomUUID();
        this.onChangeCallbacks.put(id, onChangeCallback);
        return () -> this.onChangeCallbacks.remove(id);
    }

    @Override
    public class_2487 serializeNBT() {
        class_2487 data = new class_2487();
        this.slotMap.forEach((index, slot) -> data.method_10566(index.toString(), (class_2520)slot.serializeNBT()));
        return data;
    }

    @Override
    public void deserializeNBT(class_2487 nbt) {
        this.slotMap.clear();
        nbt.method_10541().forEach(indexRep -> {
            int index = Integer.parseInt(indexRep);
            BitSlot slot = new BitSlot();
            slot.deserializeNBT(nbt.method_10562(indexRep));
            this.slotMap.put(index, (Object)slot);
        });
        this.onChange();
    }

    protected Collection<BitSlot> getContents() {
        return this.slotMap.values();
    }

    protected void onChange() {
        this.onChangeCallbacks.values().forEach(Runnable::run);
    }

    @Override
    public boolean method_5442() {
        return this.slotMap.isEmpty() || this.slotMap.values().stream().allMatch(slot -> slot.getCount() == 0);
    }

    protected static final class BitSlot
    implements INBTSerializable<class_2487>,
    IPacketBufferSerializable {
        private IBlockInformation blockInformation = BlockInformation.AIR;
        private class_1799 internalStack = class_1799.field_8037;

        public BitSlot() {
        }

        public BitSlot(IBlockInformation blockInformation, int count) {
            this.blockInformation = blockInformation;
            this.internalStack = IBitItemManager.getInstance().create(blockInformation, count);
        }

        @Override
        public void serializeInto(@NotNull class_2540 packetBuffer) {
            this.blockInformation.serializeInto(packetBuffer);
            packetBuffer.method_10804(this.getCount());
        }

        @Override
        public void deserializeFrom(@NotNull class_2540 packetBuffer) {
            this.blockInformation = new BlockInformation(packetBuffer);
            int count = packetBuffer.method_10816();
            this.internalStack = IBitItemManager.getInstance().create(this.blockInformation, count);
        }

        @Override
        public class_2487 serializeNBT() {
            class_2487 data = new class_2487();
            data.method_10566("block_information", this.blockInformation.serializeNBT());
            data.method_10569("count", this.getCount());
            return data;
        }

        @Override
        public void deserializeNBT(class_2487 nbt) {
            this.blockInformation = new BlockInformation(nbt.method_10562("block_information"));
            int count = nbt.method_10550("count");
            this.internalStack = IBitItemManager.getInstance().create(this.blockInformation, count);
        }

        public IBlockInformation getBlockInformation() {
            return this.blockInformation;
        }

        public int getCount() {
            return this.internalStack.method_7947();
        }

        public void setBlockInformation(IBlockInformation blockInformation) {
            if (this.blockInformation.equals(blockInformation)) {
                return;
            }
            this.blockInformation = blockInformation;
            this.internalStack = IBitItemManager.getInstance().create(blockInformation, 1);
        }

        public void setCount(int count) {
            this.internalStack.method_7939(count);
        }
    }
}

