/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.client.variant.state;

import com.communi.suggestu.scena.core.client.models.data.IBlockModelData;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import mod.chiselsandbits.api.blockinformation.IBlockInformation;
import mod.chiselsandbits.api.client.variant.state.IClientStateVariantManager;
import mod.chiselsandbits.api.client.variant.state.IClientStateVariantProvider;
import mod.chiselsandbits.api.variant.state.IStateVariant;
import net.minecraft.class_1836;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2561;

public final class ClientStateVariantManager
implements IClientStateVariantManager {
    private static final ClientStateVariantManager INSTANCE = new ClientStateVariantManager();
    private final Map<Supplier<class_2248>, IClientStateVariantProvider> preBakeProviders = new ConcurrentHashMap<Supplier<class_2248>, IClientStateVariantProvider>();
    private final Map<class_2248, IClientStateVariantProvider> providers = new ConcurrentHashMap<class_2248, IClientStateVariantProvider>();

    public static ClientStateVariantManager getInstance() {
        return INSTANCE;
    }

    private ClientStateVariantManager() {
    }

    @Override
    public IClientStateVariantManager registerStateVariantProvider(Supplier<class_2248> block, IClientStateVariantProvider provider) {
        this.preBakeProviders.put(block, provider);
        return this;
    }

    private void bakeProviders() {
        if (!this.providers.isEmpty()) {
            return;
        }
        this.preBakeProviders.forEach((block, provider) -> this.providers.put((class_2248)block.get(), (IClientStateVariantProvider)provider));
        this.preBakeProviders.clear();
    }

    @Override
    public IBlockModelData getBlockModelData(IBlockInformation blockInformation) {
        this.bakeProviders();
        if (blockInformation.getVariant().isEmpty() || !this.providers.containsKey(blockInformation.getBlockState().method_26204())) {
            return IBlockModelData.empty();
        }
        return this.providers.get(blockInformation.getBlockState().method_26204()).getBlockModelData(blockInformation.getVariant().get());
    }

    @Override
    public void appendHoverText(IBlockInformation blockInformation, class_1937 level, List<class_2561> tooltip, class_1836 flags) {
        this.bakeProviders();
        if (blockInformation.getVariant().isEmpty() || !this.providers.containsKey(blockInformation.getBlockState().method_26204())) {
            return;
        }
        ArrayList variantLines = new ArrayList();
        blockInformation.getVariant().ifPresent(variant -> this.providers.get(blockInformation.getBlockState().method_26204()).appendHoverText((IStateVariant)variant, level, variantLines, flags));
        if (!variantLines.isEmpty()) {
            tooltip.add((class_2561)class_2561.method_43470((String)""));
            tooltip.addAll(variantLines);
        }
    }
}

