/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.client.model.baked.chiseled;

import com.communi.suggestu.scena.core.client.models.data.IBlockModelData;
import java.util.Collection;
import java.util.Map;
import java.util.function.Supplier;
import java.util.stream.Stream;
import mod.chiselsandbits.api.config.IClientConfiguration;
import mod.chiselsandbits.api.item.multistate.IMultiStateItem;
import mod.chiselsandbits.api.item.multistate.IMultiStateItemStack;
import mod.chiselsandbits.api.profiling.IProfilerSection;
import mod.chiselsandbits.client.model.baked.base.BaseSmartModel;
import mod.chiselsandbits.client.model.baked.chiseled.ChiselRenderType;
import mod.chiselsandbits.client.model.baked.chiseled.ChiseledBlockBakedModel;
import mod.chiselsandbits.client.model.baked.chiseled.ChiseledBlockBakedModelManager;
import mod.chiselsandbits.client.model.baked.simple.CombinedModel;
import mod.chiselsandbits.client.model.baked.simple.NullBakedModel;
import mod.chiselsandbits.client.util.BlockInformationUtils;
import mod.chiselsandbits.profiling.ProfilingManager;
import mod.chiselsandbits.registrars.ModModelProperties;
import mod.chiselsandbits.utils.SimpleMaxSizedCache;
import net.minecraft.class_1087;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1921;
import net.minecraft.class_2487;
import net.minecraft.class_2680;
import net.minecraft.class_5819;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DataAwareChiseledBlockBakedModel
extends BaseSmartModel {
    private static final SimpleMaxSizedCache<class_2487, class_1087> STACK_MODEL_CACHE = new SimpleMaxSizedCache(((Supplier<Long>)IClientConfiguration.getInstance().getStackModelCacheSize())::get);

    @Override
    public boolean method_4708() {
        return true;
    }

    public boolean method_24304() {
        return true;
    }

    @Override
    public class_1087 handleBlockState(class_2680 state, class_5819 random, IBlockModelData modelData) {
        if (!modelData.hasProperty(ModModelProperties.UNKNOWN_LAYER_MODEL_PROPERTY)) {
            return NullBakedModel.instance;
        }
        return (class_1087)modelData.getData(ModModelProperties.UNKNOWN_LAYER_MODEL_PROPERTY);
    }

    @Override
    public class_1087 handleBlockState(class_2680 state, class_5819 random, IBlockModelData modelData, @Nullable class_1921 renderType) {
        if (!modelData.hasProperty(ModModelProperties.KNOWN_LAYER_MODEL_PROPERTY) && !modelData.hasProperty(ModModelProperties.UNKNOWN_LAYER_MODEL_PROPERTY)) {
            return NullBakedModel.instance;
        }
        if (!modelData.hasProperty(ModModelProperties.KNOWN_LAYER_MODEL_PROPERTY) || renderType == null) {
            return (class_1087)modelData.getData(ModModelProperties.UNKNOWN_LAYER_MODEL_PROPERTY);
        }
        return ((Map)modelData.getData(ModModelProperties.KNOWN_LAYER_MODEL_PROPERTY)).getOrDefault(renderType, NullBakedModel.instance);
    }

    @Override
    @NotNull
    public Collection<class_1921> getSupportedRenderTypes(class_2680 blockState, class_5819 randomSource, IBlockModelData iBlockModelData) {
        if (!iBlockModelData.hasProperty(ModModelProperties.KNOWN_LAYER_MODEL_PROPERTY)) {
            return super.getSupportedRenderTypes(blockState, randomSource, iBlockModelData);
        }
        return ((Map)iBlockModelData.getData(ModModelProperties.KNOWN_LAYER_MODEL_PROPERTY)).keySet();
    }

    @Override
    public class_1087 handleItemStack(class_1799 stack) {
        class_1792 item = stack.method_7909();
        if (!(item instanceof IMultiStateItem)) {
            return NullBakedModel.instance;
        }
        IMultiStateItem multiStateItem = (IMultiStateItem)item;
        class_2487 cacheKey = stack.method_7953(new class_2487());
        return STACK_MODEL_CACHE.get(cacheKey, () -> {
            class_1087[] typedModels;
            IMultiStateItemStack multiStateItemStack = multiStateItem.createItemStack(stack);
            try (IProfilerSection ignored1 = ProfilingManager.getInstance().withSection("Building individual render type models");){
                typedModels = (class_1087[])BlockInformationUtils.extractRenderTypes(multiStateItemStack.getStatistics().getContainedStates()).stream().flatMap(type -> {
                    ChiseledBlockBakedModel fluidModel = ChiseledBlockBakedModelManager.getInstance().get(multiStateItemStack, ChiselRenderType.fromLayer(type, true), (class_1921)type);
                    ChiseledBlockBakedModel solidModel = ChiseledBlockBakedModelManager.getInstance().get(multiStateItemStack, ChiselRenderType.fromLayer(type, false), (class_1921)type);
                    return Stream.of(fluidModel, solidModel);
                }).toArray(class_1087[]::new);
            }
            if (typedModels.length == 0) {
                return ChiseledBlockBakedModel.EMPTY;
            }
            ignored1 = ProfilingManager.getInstance().withSection("Combining model data");
            try {
                CombinedModel combinedModel = new CombinedModel(typedModels);
                return combinedModel;
            }
            finally {
                if (ignored1 != null) {
                    ignored1.close();
                }
            }
        });
    }
}

