/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.client.model.baked.chiseled;

import java.util.function.Function;
import mod.chiselsandbits.api.blockinformation.IBlockInformation;
import mod.chiselsandbits.api.config.IClientConfiguration;
import mod.chiselsandbits.api.item.multistate.IMultiStateItemStack;
import mod.chiselsandbits.api.multistate.accessor.IAreaAccessor;
import mod.chiselsandbits.api.multistate.accessor.IStateEntryInfo;
import mod.chiselsandbits.api.multistate.accessor.identifier.IAreaShapeIdentifier;
import mod.chiselsandbits.api.neighborhood.IBlockNeighborhood;
import mod.chiselsandbits.api.neighborhood.IBlockNeighborhoodBuilder;
import mod.chiselsandbits.api.profiling.IProfilerSection;
import mod.chiselsandbits.api.util.VectorUtils;
import mod.chiselsandbits.blockinformation.BlockInformation;
import mod.chiselsandbits.client.model.baked.chiseled.ChiselRenderType;
import mod.chiselsandbits.client.model.baked.chiseled.ChiseledBlockBakedModel;
import mod.chiselsandbits.profiling.ProfilingManager;
import mod.chiselsandbits.utils.SimpleMaxSizedCache;
import net.minecraft.class_1921;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ChiseledBlockBakedModelManager {
    private static final ChiseledBlockBakedModelManager INSTANCE = new ChiseledBlockBakedModelManager();
    private final SimpleMaxSizedCache<Key, ChiseledBlockBakedModel> cache = new SimpleMaxSizedCache(() -> IClientConfiguration.getInstance().getModelCacheSize().get() * (long)class_1921.method_22720().size());

    private ChiseledBlockBakedModelManager() {
    }

    public static ChiseledBlockBakedModelManager getInstance() {
        return INSTANCE;
    }

    public void clearCache() {
        this.cache.clear();
    }

    public ChiseledBlockBakedModel get(@NotNull IMultiStateItemStack multiStateItemStack, @NotNull ChiselRenderType chiselRenderType, @NotNull class_1921 renderType) {
        try (IProfilerSection ignored = ProfilingManager.getInstance().withSection("Item based chiseled block model");){
            ChiseledBlockBakedModel chiseledBlockBakedModel = this.get(multiStateItemStack, multiStateItemStack.getStatistics().getPrimaryState(), chiselRenderType, null, null, class_2338.field_10980, renderType);
            return chiseledBlockBakedModel;
        }
    }

    public ChiseledBlockBakedModel get(@NotNull IAreaAccessor accessor, @NotNull BlockInformation primaryState, @NotNull ChiselRenderType chiselRenderType, @NotNull class_1921 renderType) {
        return this.get(accessor, primaryState, chiselRenderType, null, null, class_2338.field_10980, renderType);
    }

    public ChiseledBlockBakedModel get(IAreaAccessor accessor, IBlockInformation primaryState, ChiselRenderType chiselRenderType, @Nullable Function<class_2350, IBlockInformation> neighborhoodBlockInformationProvider, @Nullable Function<class_2350, IAreaAccessor> neighborhoodAreaAccessorProvider, @NotNull class_2338 position, @NotNull class_1921 renderType) {
        try (IProfilerSection ignored1 = ProfilingManager.getInstance().withSection("Block based chiseled block model");){
            ChiseledBlockBakedModel chiseledBlockBakedModel = this.get(accessor, primaryState, chiselRenderType, IBlockNeighborhoodBuilder.getInstance().build(neighborhoodBlockInformationProvider, neighborhoodAreaAccessorProvider), position, renderType);
            return chiseledBlockBakedModel;
        }
    }

    public ChiseledBlockBakedModel get(IAreaAccessor accessor, IBlockInformation primaryState, ChiselRenderType chiselRenderType, @NotNull IBlockNeighborhood blockNeighborhood, @NotNull class_2338 position, @NotNull class_1921 renderType) {
        try (IProfilerSection ignored1 = ProfilingManager.getInstance().withSection("Block based chiseled block model");){
            long primaryStateRenderSeed = primaryState.getBlockState().method_26190(position);
            Key key = new Key(accessor.createNewShapeIdentifier(), primaryState, chiselRenderType, blockNeighborhood, primaryStateRenderSeed, renderType);
            ChiseledBlockBakedModel chiseledBlockBakedModel = this.cache.get(key, () -> {
                try (IProfilerSection ignored3 = ProfilingManager.getInstance().withSection("Cache mis");){
                    ChiseledBlockBakedModel chiseledBlockBakedModel = new ChiseledBlockBakedModel(primaryState, chiselRenderType, accessor, targetOffset -> {
                        class_243 nominalTargetOffset = class_243.field_1353.method_1019(targetOffset);
                        class_2338 nominalTargetBlockOffset = VectorUtils.toBlockPos(nominalTargetOffset);
                        class_243 inBlockOffset = nominalTargetOffset.method_1020(class_243.method_24954((class_2382)nominalTargetBlockOffset));
                        class_243 inBlockOffsetTarget = VectorUtils.makePositive(inBlockOffset);
                        class_2350 offsetDirection = class_2350.method_10147((float)nominalTargetBlockOffset.method_10263(), (float)nominalTargetBlockOffset.method_10264(), (float)nominalTargetBlockOffset.method_10260());
                        IAreaAccessor neighborAccessor = targetOffset.method_10216() >= 0.0 && targetOffset.method_10216() < 1.0 && targetOffset.method_10214() >= 0.0 && targetOffset.method_10214() < 1.0 && targetOffset.method_10215() >= 0.0 && targetOffset.method_10215() < 1.0 ? accessor : blockNeighborhood.getAreaAccessor(offsetDirection);
                        if (neighborAccessor != null) {
                            return neighborAccessor.getInAreaTarget(inBlockOffsetTarget).map(IStateEntryInfo::getBlockInformation).orElse(BlockInformation.AIR);
                        }
                        return blockNeighborhood.getBlockInformation(offsetDirection);
                    }, primaryStateRenderSeed);
                    return chiseledBlockBakedModel;
                }
            });
            return chiseledBlockBakedModel;
        }
    }

    private record Key(IAreaShapeIdentifier identifier, IBlockInformation primaryState, ChiselRenderType chiselRenderType, IBlockNeighborhood neighborhood, long renderSeed, class_1921 renderType) {
    }
}

