/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.client.model.baked.chiseled;

import com.communi.suggestu.scena.core.client.rendering.type.IRenderTypeManager;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.security.InvalidParameterException;
import java.util.Collection;
import mod.chiselsandbits.api.blockinformation.IBlockInformation;
import mod.chiselsandbits.api.multistate.accessor.IAreaAccessor;
import mod.chiselsandbits.api.multistate.accessor.IStateEntryInfo;
import mod.chiselsandbits.client.culling.ICullTest;
import mod.chiselsandbits.client.culling.MCCullTest;
import mod.chiselsandbits.client.model.baked.chiseled.VoxelType;
import net.minecraft.class_1921;

public enum ChiselRenderType {
    SOLID(class_1921.method_23577(), VoxelType.SOLID),
    SOLID_FLUID(class_1921.method_23577(), VoxelType.FLUID),
    CUTOUT(class_1921.method_23581(), VoxelType.UNKNOWN),
    CUTOUT_MIPPED(class_1921.method_23579(), VoxelType.UNKNOWN),
    TRANSLUCENT(class_1921.method_23583(), VoxelType.UNKNOWN),
    TRANSLUCENT_FLUID(class_1921.method_23583(), VoxelType.FLUID),
    TRIPWIRE(class_1921.method_29997(), VoxelType.UNKNOWN);

    public final class_1921 layer;
    public final VoxelType type;
    private static final Multimap<VoxelType, ChiselRenderType> TYPED_RENDER_TYPES;

    private ChiselRenderType(class_1921 layer, VoxelType type) {
        this.layer = layer;
        this.type = type;
    }

    public boolean isRequiredForRendering(IAreaAccessor accessor) {
        if (accessor == null) {
            return false;
        }
        return accessor.stream().anyMatch(this::isRequiredForRendering);
    }

    public boolean isRequiredForRendering(IStateEntryInfo stateEntryInfo) {
        return this.isRequiredForRendering(stateEntryInfo.getBlockInformation());
    }

    public boolean isRequiredForRendering(IBlockInformation state) {
        if (state.isAir() || !this.type.isValidBlockState(state)) {
            return false;
        }
        if (this.type.isFluid()) {
            return IRenderTypeManager.getInstance().canRenderInType(state.getBlockState().method_26227(), this.layer);
        }
        return IRenderTypeManager.getInstance().canRenderInType(state.getBlockState(), this.layer);
    }

    public static ChiselRenderType fromLayer(class_1921 layerInfo, boolean isFluid) {
        if (layerInfo == null) {
            layerInfo = class_1921.method_23577();
        }
        if (ChiselRenderType.CUTOUT.layer.equals(layerInfo)) {
            return CUTOUT;
        }
        if (ChiselRenderType.CUTOUT_MIPPED.layer.equals(layerInfo)) {
            return CUTOUT_MIPPED;
        }
        if (ChiselRenderType.SOLID.layer.equals(layerInfo)) {
            return isFluid ? SOLID_FLUID : SOLID;
        }
        if (ChiselRenderType.TRANSLUCENT.layer.equals(layerInfo)) {
            return isFluid ? TRANSLUCENT_FLUID : TRANSLUCENT;
        }
        if (ChiselRenderType.TRIPWIRE.layer.equals(layerInfo)) {
            return TRIPWIRE;
        }
        throw new InvalidParameterException();
    }

    public static Collection<ChiselRenderType> getRenderTypes(VoxelType voxelType) {
        return TYPED_RENDER_TYPES.get((Object)voxelType);
    }

    public ICullTest getTest() {
        return new MCCullTest();
    }

    static {
        TYPED_RENDER_TYPES = HashMultimap.create();
        for (ChiselRenderType value : ChiselRenderType.values()) {
            TYPED_RENDER_TYPES.put((Object)value.type, (Object)value);
        }
    }
}

