/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.client.logic;

import mod.chiselsandbits.api.client.render.preview.placement.PlacementPreviewRenderMode;
import mod.chiselsandbits.api.config.IClientConfiguration;
import mod.chiselsandbits.api.item.multistate.IMultiStateItemStack;
import mod.chiselsandbits.api.item.pattern.IPatternItem;
import mod.chiselsandbits.api.item.wireframe.IWireframeProvidingItem;
import mod.chiselsandbits.api.multistate.StateEntrySize;
import mod.chiselsandbits.api.placement.IPlacementPreviewProvidingItem;
import mod.chiselsandbits.api.placement.PlacementResult;
import mod.chiselsandbits.client.render.ChiseledBlockGhostRenderer;
import mod.chiselsandbits.client.render.ChiseledBlockWireframeRenderer;
import mod.chiselsandbits.utils.ItemStackUtils;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_265;
import net.minecraft.class_310;
import net.minecraft.class_3965;
import net.minecraft.class_4587;
import net.minecraft.class_746;
import org.joml.Vector4f;

public class MultiStateBlockPreviewRenderHandler {
    public static void renderMultiStateBlockPreview(class_4587 poseStack) {
        boolean forceWireframe;
        boolean ignoreDepth;
        PlacementResult placementResult;
        class_3965 blockRayTraceResult;
        class_239 rayTraceResult = class_310.method_1551().field_1765;
        if (!(rayTraceResult instanceof class_3965) || (blockRayTraceResult = (class_3965)rayTraceResult).method_17783() == class_239.class_240.field_1333) {
            return;
        }
        class_746 playerEntity = class_310.method_1551().field_1724;
        if (playerEntity == null || playerEntity.method_7325()) {
            return;
        }
        class_1799 heldStack = ItemStackUtils.getMultiStateItemStackFromPlayer((class_1657)playerEntity);
        class_1792 class_17922 = heldStack.method_7909();
        if (!(class_17922 instanceof IWireframeProvidingItem)) {
            return;
        }
        IWireframeProvidingItem wireframeItem = (IWireframeProvidingItem)class_17922;
        class_243 targetedRenderPos = wireframeItem.getTargetedPosition(heldStack, (class_1657)playerEntity, blockRayTraceResult).method_1031((double)0.001f, (double)0.001f, (double)0.001f);
        float bitSize = StateEntrySize.current().getSizePerBit();
        targetedRenderPos = targetedRenderPos.method_1023(targetedRenderPos.field_1352 % (double)bitSize + (double)(targetedRenderPos.field_1352 < 0.0 ? bitSize : 0.0f), targetedRenderPos.field_1351 % (double)bitSize + (double)(targetedRenderPos.field_1351 < 0.0 ? bitSize : 0.0f), targetedRenderPos.field_1350 % (double)bitSize + (double)(targetedRenderPos.field_1350 < 0.0 ? bitSize : 0.0f));
        class_1792 class_17923 = heldStack.method_7909();
        if (class_17923 instanceof IPlacementPreviewProvidingItem) {
            IPlacementPreviewProvidingItem placementPreviewItem = (IPlacementPreviewProvidingItem)class_17923;
            placementResult = placementPreviewItem.getPlacementResult(heldStack, (class_1657)playerEntity, blockRayTraceResult);
            ignoreDepth = placementPreviewItem.ignoreDepthForPlacement(heldStack, placementResult);
            forceWireframe = false;
        } else {
            placementResult = PlacementResult.failure(wireframeItem.getWireFrameColor(heldStack, (class_1657)playerEntity, blockRayTraceResult));
            ignoreDepth = wireframeItem.ignoreDepth(heldStack);
            forceWireframe = true;
        }
        IClientConfiguration clientConfig = IClientConfiguration.getInstance();
        PlacementPreviewRenderMode success = clientConfig.getSuccessfulPlacementRenderMode().get();
        PlacementPreviewRenderMode failure = clientConfig.getFailedPlacementRenderMode().get();
        if (forceWireframe || placementResult.isSuccess() && success.isWireframe() || !placementResult.isSuccess() && failure.isWireframe() || !MultiStateBlockPreviewRenderHandler.renderGhost(poseStack, heldStack, targetedRenderPos, placementResult, success, failure, ignoreDepth)) {
            MultiStateBlockPreviewRenderHandler.renderWireFrame(poseStack, (class_1657)playerEntity, heldStack, wireframeItem, blockRayTraceResult, targetedRenderPos, placementResult.getColor(), ignoreDepth);
        }
    }

    private static void renderWireFrame(class_4587 poseStack, class_1657 playerEntity, class_1799 heldStack, IWireframeProvidingItem wireframeItem, class_3965 blockRayTraceResult, class_243 targetedRenderPos, Vector4f color, boolean ignoreDepth) {
        class_265 wireFrame = wireframeItem.getWireFrame(heldStack, playerEntity, blockRayTraceResult);
        ChiseledBlockWireframeRenderer.getInstance().renderShape(poseStack, wireFrame, targetedRenderPos, color, ignoreDepth);
    }

    private static boolean renderGhost(class_4587 poseStack, class_1799 heldStack, class_243 targetedRenderPos, PlacementResult placementResult, PlacementPreviewRenderMode success, PlacementPreviewRenderMode failure, boolean ignoreDepth) {
        class_1799 renderStack;
        class_1792 class_17922 = heldStack.method_7909();
        if (class_17922 instanceof IPatternItem) {
            IPatternItem patternItem = (IPatternItem)class_17922;
            IMultiStateItemStack multiSate = patternItem.createItemStack(heldStack);
            renderStack = multiSate.toBlockStack();
            if (renderStack.method_7960()) {
                return false;
            }
        } else {
            renderStack = heldStack;
        }
        ChiseledBlockGhostRenderer.getInstance().renderGhost(poseStack, renderStack, targetedRenderPos, placementResult, success, failure, ignoreDepth);
        return true;
    }
}

