/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.client.besr;

import com.communi.suggestu.scena.core.client.fluid.IClientFluidManager;
import com.communi.suggestu.scena.core.client.rendering.IRenderingManager;
import com.communi.suggestu.scena.core.client.rendering.type.IRenderTypeManager;
import com.communi.suggestu.scena.core.fluid.FluidInformation;
import com.communi.suggestu.scena.core.fluid.IFluidManager;
import com.google.common.collect.Sets;
import java.util.Set;
import java.util.function.Supplier;
import mod.chiselsandbits.api.block.storage.IStateEntryStorage;
import mod.chiselsandbits.api.blockinformation.IBlockInformation;
import mod.chiselsandbits.api.config.IClientConfiguration;
import mod.chiselsandbits.block.entities.BitStorageBlockEntity;
import mod.chiselsandbits.block.entities.storage.SimpleStateEntryStorage;
import mod.chiselsandbits.client.model.baked.chiseled.ChiselRenderType;
import mod.chiselsandbits.client.model.baked.chiseled.ChiseledBlockBakedModel;
import mod.chiselsandbits.client.model.baked.chiseled.ChiseledBlockBakedModelManager;
import mod.chiselsandbits.client.util.BlockInformationUtils;
import mod.chiselsandbits.client.util.FluidCuboidUtils;
import mod.chiselsandbits.utils.MultiStateSnapshotUtils;
import mod.chiselsandbits.utils.SimpleMaxSizedCache;
import net.minecraft.class_1087;
import net.minecraft.class_1799;
import net.minecraft.class_1921;
import net.minecraft.class_1935;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4722;
import net.minecraft.class_827;
import org.jetbrains.annotations.NotNull;

public class BitStorageBESR
implements class_827<BitStorageBlockEntity> {
    private static final SimpleMaxSizedCache<CacheKey, IStateEntryStorage> STORAGE_CONTENTS_BLOB_CACHE = new SimpleMaxSizedCache(((Supplier<Long>)IClientConfiguration.getInstance().getBitStorageContentCacheSize())::get);

    public static void clearCache() {
        STORAGE_CONTENTS_BLOB_CACHE.clear();
    }

    public void render(BitStorageBlockEntity te, float partialTicks, @NotNull class_4587 poseStack, @NotNull class_4597 buffer, int combinedLightIn, int combinedOverlayIn) {
        if (te.containsFluid()) {
            FluidInformation fluidStack = te.getFluid().get();
            class_1921.method_22720().forEach(renderType -> {
                if (!IRenderTypeManager.getInstance().canRenderInType(fluidStack.fluid().method_15785(), renderType)) {
                    return;
                }
                if (renderType == class_1921.method_23583() && class_310.method_29611()) {
                    renderType = class_4722.method_24076();
                }
                class_4588 builder = buffer.getBuffer(renderType);
                float fullness = (float)fluidStack.amount() / (float)IFluidManager.getInstance().getBucketAmount();
                float heightFactor = Math.min(Math.max(0.0f, fullness), 1.0f);
                FluidCuboidUtils.renderScaledFluidCuboid(fluidStack, poseStack, builder, combinedLightIn, combinedOverlayIn, 1.0f, 1.0f, 1.0f, 15.0f, 15.0f * heightFactor, 15.0f);
            });
            return;
        }
        int bits = te.getBits();
        IBlockInformation blockInformation = te.getContainedBlockInformation();
        if (bits <= 0 || blockInformation == null) {
            return;
        }
        CacheKey cacheKey = new CacheKey(blockInformation, bits);
        IStateEntryStorage innerModelBlob = STORAGE_CONTENTS_BLOB_CACHE.get(cacheKey);
        if (innerModelBlob == null) {
            innerModelBlob = new SimpleStateEntryStorage();
            innerModelBlob.fillFromBottom(blockInformation, bits);
            STORAGE_CONTENTS_BLOB_CACHE.put(cacheKey, innerModelBlob);
        }
        poseStack.method_22903();
        poseStack.method_46416(0.125f, 0.125f, 0.125f);
        poseStack.method_22905(0.75f, 0.75f, 0.75f);
        IStateEntryStorage finalInnerModelBlob = innerModelBlob;
        Set<class_1921> renderTypes = BlockInformationUtils.extractRenderTypes(Sets.newHashSet((Object[])new IBlockInformation[]{blockInformation}));
        renderTypes.forEach(renderType -> {
            ChiseledBlockBakedModel innerModel = ChiseledBlockBakedModelManager.getInstance().get(MultiStateSnapshotUtils.createFromStorage(finalInnerModelBlob), blockInformation, ChiselRenderType.fromLayer(renderType, te.containsFluid()), null, null, te.method_11016(), (class_1921)renderType);
            if (!innerModel.isEmpty()) {
                float b;
                float g;
                float r;
                if (te.containsFluid()) {
                    r = (float)te.getFluid().map(arg_0 -> ((IClientFluidManager)IClientFluidManager.getInstance()).getFluidColor(arg_0)).map(color -> color >> 16 & 0xFF).orElse(255).intValue() / 255.0f;
                    g = (float)te.getFluid().map(arg_0 -> ((IClientFluidManager)IClientFluidManager.getInstance()).getFluidColor(arg_0)).map(color -> color >> 8 & 0xFF).orElse(255).intValue() / 255.0f;
                    b = (float)te.getFluid().map(arg_0 -> ((IClientFluidManager)IClientFluidManager.getInstance()).getFluidColor(arg_0)).map(color -> color & 0xFF).orElse(255).intValue() / 255.0f;
                } else {
                    int color2 = class_310.method_1551().field_1760.method_1704(new class_1799((class_1935)blockInformation.getBlockState().method_26204()), 0);
                    r = (float)(color2 >> 16 & 0xFF) / 255.0f;
                    g = (float)(color2 >> 8 & 0xFF) / 255.0f;
                    b = (float)(color2 & 0xFF) / 255.0f;
                }
                IRenderingManager.getInstance().renderModel(poseStack.method_23760(), buffer.getBuffer(renderType), blockInformation.getBlockState(), (class_1087)innerModel, r, g, b, combinedLightIn, combinedOverlayIn, renderType);
            }
        });
        poseStack.method_22909();
    }

    private record CacheKey(IBlockInformation blockInformation, int bitCount) {
    }
}

