/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.change.changes;

import java.util.ArrayList;
import java.util.Collection;
import java.util.stream.Collectors;
import mod.chiselsandbits.api.change.changes.IChange;
import mod.chiselsandbits.api.change.changes.IllegalChangeAttempt;
import mod.chiselsandbits.api.util.INBTSerializable;
import mod.chiselsandbits.change.changes.BitChange;
import net.minecraft.class_1657;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import org.apache.commons.lang3.Validate;

public class CombinedChange
implements IChange {
    private final Collection<IChange> changes;

    public CombinedChange(Collection<IChange> changes) {
        this.changes = changes;
    }

    public CombinedChange(class_2520 tag) {
        Validate.isInstanceOf(class_2487.class, (Object)tag);
        this.changes = new ArrayList<IChange>();
        this.deserializeNBT((class_2487)tag);
    }

    @Override
    public boolean canUndo(class_1657 player) {
        for (IChange change : this.changes) {
            if (change.canUndo(player)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean canRedo(class_1657 player) {
        for (IChange change : this.changes) {
            if (change.canRedo(player)) continue;
            return false;
        }
        return true;
    }

    @Override
    public void undo(class_1657 player) throws IllegalChangeAttempt {
        for (IChange change : this.changes) {
            change.undo(player);
        }
    }

    @Override
    public void redo(class_1657 player) throws IllegalChangeAttempt {
        for (IChange change : this.changes) {
            change.redo(player);
        }
    }

    @Override
    public class_2487 serializeNBT() {
        class_2487 tag = new class_2487();
        tag.method_10566("changes", (class_2520)this.changes.stream().map(INBTSerializable::serializeNBT).collect(Collectors.toCollection(class_2499::new)));
        return tag;
    }

    @Override
    public void deserializeNBT(class_2487 nbt) {
        class_2499 tag = nbt.method_10554("changes", 10);
        this.changes.clear();
        this.changes.addAll(tag.stream().map(BitChange::new).collect(Collectors.toList()));
    }
}

