/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.api.util;

import com.google.common.base.MoreObjects;
import com.mojang.serialization.Codec;
import java.util.stream.IntStream;
import net.minecraft.class_156;
import net.minecraft.class_2350;
import net.minecraft.class_2374;
import net.minecraft.class_3532;

public class Vector2i
implements Comparable<Vector2i> {
    public static final Codec<Vector2i> CODEC = Codec.INT_STREAM.comapFlatMap(stream -> class_156.method_29190((IntStream)stream, (int)3).map(componentArray -> new Vector2i(componentArray[0], componentArray[1])), vector -> IntStream.of(vector.getX(), vector.getY()));
    public static final Vector2i NULL_VECTOR = new Vector2i(0, 0);
    private int x;
    private int y;

    public Vector2i(double xIn, double yIn) {
        this(class_3532.method_15357((double)xIn), class_3532.method_15357((double)yIn));
    }

    public Vector2i(int xIn, int yIn) {
        this.x = xIn;
        this.y = yIn;
    }

    public int hashCode() {
        return this.getY() * 31 + this.getX();
    }

    public boolean equals(Object p_equals_1_) {
        if (this == p_equals_1_) {
            return true;
        }
        if (!(p_equals_1_ instanceof Vector2i)) {
            return false;
        }
        Vector2i Vector2i2 = (Vector2i)p_equals_1_;
        if (this.getX() != Vector2i2.getX()) {
            return false;
        }
        return this.getY() == Vector2i2.getY();
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    protected void setY(int yIn) {
        this.y = yIn;
    }

    protected void setX(int xIn) {
        this.x = xIn;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("x", this.getX()).add("y", this.getY()).toString();
    }

    @Override
    public int compareTo(Vector2i p_compareTo_1_) {
        if (this.getY() == p_compareTo_1_.getY()) {
            return this.getX() - p_compareTo_1_.getX();
        }
        return this.getY() - p_compareTo_1_.getY();
    }

    public Vector2i up() {
        return this.up(1);
    }

    public Vector2i up(int n) {
        return this.offset(class_2350.field_11036, n);
    }

    public Vector2i offset(class_2350 facing, int n) {
        return n == 0 ? this : new Vector2i(this.getX() + facing.method_10148() * n, this.getY() + facing.method_10164() * n);
    }

    public Vector2i down() {
        return this.down(1);
    }

    public Vector2i down(int n) {
        return this.offset(class_2350.field_11033, n);
    }

    public boolean withinDistance(Vector2i vector, double distance) {
        return this.distanceSq(vector.getX(), vector.getY(), false) < distance * distance;
    }

    public double distanceSq(double x, double y, boolean useCenter) {
        double d0 = useCenter ? 0.5 : 0.0;
        double d1 = (double)this.getX() + d0 - x;
        double d2 = (double)this.getY() + d0 - y;
        return d1 * d1 + d2 * d2;
    }

    public boolean withinDistance(class_2374 position, double distance) {
        return this.distanceSq(position.method_10216(), position.method_10214(), true) < distance * distance;
    }

    public double distanceSq(Vector2i to) {
        return this.distanceSq(to.getX(), to.getY(), true);
    }

    public int manhattanDistance(Vector2i vector) {
        float f = Math.abs(vector.getX() - this.getX());
        float f1 = Math.abs(vector.getY() - this.getY());
        return (int)(f + f1);
    }

    public String getCoordinatesAsString() {
        return this.getX() + ", " + this.getY();
    }
}

