/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.aabb;

import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import mod.chiselsandbits.aabb.AABBCompressor;
import mod.chiselsandbits.api.axissize.CollisionType;
import mod.chiselsandbits.api.config.IChiselsAndBitsConfiguration;
import mod.chiselsandbits.api.multistate.accessor.IAreaAccessor;
import mod.chiselsandbits.api.multistate.accessor.identifier.IAreaShapeIdentifier;
import mod.chiselsandbits.utils.SimpleMaxSizedCache;
import net.minecraft.class_238;

public class AABBManager {
    private static final AABBManager INSTANCE = new AABBManager();
    private final SimpleMaxSizedCache<Key, List<class_238>> cache = new SimpleMaxSizedCache(((Supplier<Long>)IChiselsAndBitsConfiguration.getInstance().getCommon().getCollisionBoxCacheSize())::get);

    public static AABBManager getInstance() {
        return INSTANCE;
    }

    private AABBManager() {
    }

    public List<class_238> get(IAreaAccessor accessor, CollisionType sizeType) {
        Key cacheKey = new Key(accessor.createNewShapeIdentifier(), sizeType);
        return this.cache.get(cacheKey, () -> AABBCompressor.compressStates(accessor, sizeType));
    }

    public void clearCache() {
        this.cache.clear();
    }

    private static final class Key {
        private final IAreaShapeIdentifier identifier;
        private final CollisionType predicate;

        private Key(IAreaShapeIdentifier identifier, CollisionType predicate) {
            this.identifier = identifier;
            this.predicate = predicate;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Key)) {
                return false;
            }
            Key key = (Key)o;
            return Objects.equals(this.identifier, key.identifier) && Objects.equals((Object)this.predicate, (Object)key.predicate);
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.identifier, this.predicate});
        }
    }
}

