/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.rechiseled.registration;

import com.supermartijn642.core.CommonUtils;
import com.supermartijn642.core.generator.ResourceCache;
import com.supermartijn642.core.item.CreativeItemGroup;
import com.supermartijn642.core.registry.GeneratorRegistrationHandler;
import com.supermartijn642.core.registry.RegistryUtil;
import com.supermartijn642.core.util.Pair;
import com.supermartijn642.core.util.Triple;
import com.supermartijn642.rechiseled.api.blocks.RechiseledBlockBuilder;
import com.supermartijn642.rechiseled.api.blocks.RechiseledBlockType;
import com.supermartijn642.rechiseled.api.registration.RechiseledRegistration;
import com.supermartijn642.rechiseled.blocks.RechiseledBlockBuilderImpl;
import com.supermartijn642.rechiseled.blocks.RechiseledBlockTypeImpl;
import com.supermartijn642.rechiseled.registration.data.RegistrationBlockStateGenerator;
import com.supermartijn642.rechiseled.registration.data.RegistrationChiselingRecipeProvider;
import com.supermartijn642.rechiseled.registration.data.RegistrationFusionModelProvider;
import com.supermartijn642.rechiseled.registration.data.RegistrationLanguageGenerator;
import com.supermartijn642.rechiseled.registration.data.RegistrationLootTableGenerator;
import com.supermartijn642.rechiseled.registration.data.RegistrationModelGenerator;
import com.supermartijn642.rechiseled.registration.data.RegistrationTagsGenerator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.fabricmc.fabric.api.datagen.v1.FabricDataOutput;
import net.minecraft.class_1747;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2960;

public class RechiseledRegistrationImpl
implements RechiseledRegistration {
    private static final Map<String, RechiseledRegistrationImpl> REGISTRATION_MAP = new HashMap<String, RechiseledRegistrationImpl>();
    private static boolean finalized = false;
    private final String modid;
    private final List<RechiseledBlockBuilderImpl> unfinishedBlockBuilders = new ArrayList<RechiseledBlockBuilderImpl>();
    private final List<Pair<RechiseledBlockBuilderImpl, RechiseledBlockTypeImpl>> blockBuilders = new ArrayList<Pair<RechiseledBlockBuilderImpl, RechiseledBlockTypeImpl>>();
    private final Set<String> usedBlockIdentifiers = new HashSet<String>();
    private final List<RechiseledBlockTypeImpl> blockTypes = new ArrayList<RechiseledBlockTypeImpl>();
    private final List<Triple<class_2960, Supplier<class_1935>, Supplier<class_1935>>> chiselingEntries = new ArrayList<Triple<class_2960, Supplier<class_1935>, Supplier<class_1935>>>();
    private CreativeItemGroup itemGroup;
    private String itemGroupTranslation;
    public boolean providersRegistered = false;

    public static synchronized RechiseledRegistration get(String modid) {
        if (!RegistryUtil.isValidNamespace((String)modid)) {
            throw new RuntimeException("Invalid modid '" + modid + "'!");
        }
        if (!CommonUtils.isModLoaded((String)modid)) {
            throw new RuntimeException("Could not find any mod for modid '" + modid + "'!");
        }
        return REGISTRATION_MAP.computeIfAbsent(modid, RechiseledRegistrationImpl::new);
    }

    public static void finalizeRegistration() {
        finalized = true;
        REGISTRATION_MAP.values().forEach(registration -> {
            if (!registration.unfinishedBlockBuilders.isEmpty()) {
                if (registration.unfinishedBlockBuilders.size() == 1) {
                    throw new IllegalStateException("Found uncompleted rechiseled block builder '" + registration.modid + ":" + registration.unfinishedBlockBuilders.get(0).getIdentifier() + "'!");
                }
                String builders = registration.unfinishedBlockBuilders.stream().map(b -> "'" + registration.modid + ":" + b.getIdentifier() + "'").collect(Collectors.joining(","));
                throw new IllegalStateException("Found uncompleted rechiseled block builders " + builders + "!");
            }
        });
    }

    private RechiseledRegistrationImpl(String modid) {
        this.modid = modid;
    }

    @Override
    public synchronized RechiseledBlockBuilder block(String identifier) {
        if (finalized) {
            throw new RuntimeException("Blocks must be built during mod initialization!");
        }
        if (!this.usedBlockIdentifiers.add(identifier)) {
            throw new RuntimeException("Duplicate block builder request from '" + this.modid + "' for identifier '" + identifier + "'!");
        }
        RechiseledBlockBuilderImpl builder = new RechiseledBlockBuilderImpl(this, identifier);
        this.unfinishedBlockBuilders.add(builder);
        return builder;
    }

    @Override
    public synchronized void chiselingEntry(class_2960 recipe, Supplier<class_1935> regularItem, Supplier<class_1935> connectingItem) {
        if (finalized) {
            throw new RuntimeException("Chiseling recipe entries must be added during mod initialization!");
        }
        if (regularItem == null && connectingItem == null) {
            throw new IllegalArgumentException("Either regular item or connecting item must not be null!");
        }
        this.chiselingEntries.add((Triple<class_2960, Supplier<class_1935>, Supplier<class_1935>>)Triple.of((Object)recipe, regularItem, connectingItem));
    }

    public CreativeItemGroup itemGroup(Supplier<class_1935> icon, String translation) {
        if (finalized) {
            throw new RuntimeException("Chiseling recipe entries must be added during mod initialization!");
        }
        if (this.itemGroup != null) {
            throw new IllegalStateException("An item group for '" + this.modid + "' registration has already been created!");
        }
        this.itemGroup = CreativeItemGroup.create((String)this.modid, () -> ((class_1935)icon.get()).method_8389());
        this.itemGroup.filler(stackConsumer -> {
            LinkedList<class_1747> items = new LinkedList<class_1747>();
            for (RechiseledBlockType type : this.getAllBlockTypes()) {
                items.add(type.getRegularItem());
                items.add(type.getConnectingItem());
            }
            items.stream().filter(Objects::nonNull).map(class_1799::new).forEach((Consumer<class_1799>)stackConsumer);
        });
        this.itemGroupTranslation = translation;
        return this.itemGroup;
    }

    @Override
    public Collection<RechiseledBlockType> getAllBlockTypes() {
        return Collections.unmodifiableCollection(this.blockTypes);
    }

    @Override
    public void registerDataProviders() {
        if (this.providersRegistered) {
            throw new RuntimeException("Data providers have already been registered!");
        }
        this.providersRegistered = true;
        GeneratorRegistrationHandler handler = GeneratorRegistrationHandler.get((String)this.modid);
        handler.addProvider(generator -> new RegistrationFusionModelProvider(this, (FabricDataOutput)generator));
        handler.addGenerator(cache -> new RegistrationModelGenerator(this, (ResourceCache)cache));
        handler.addGenerator(cache -> new RegistrationBlockStateGenerator(this, (ResourceCache)cache));
        handler.addProvider(generator -> new RegistrationChiselingRecipeProvider(this, (FabricDataOutput)generator));
        handler.addGenerator(cache -> new RegistrationLanguageGenerator(this, (ResourceCache)cache));
        handler.addGenerator(cache -> new RegistrationLootTableGenerator(this, (ResourceCache)cache));
        handler.addGenerator(cache -> new RegistrationTagsGenerator(this, (ResourceCache)cache));
    }

    public String getModid() {
        return this.modid;
    }

    public void finalizeBuilder(RechiseledBlockBuilderImpl builder, RechiseledBlockTypeImpl blockType) {
        this.unfinishedBlockBuilders.remove(builder);
        this.blockBuilders.add((Pair<RechiseledBlockBuilderImpl, RechiseledBlockTypeImpl>)Pair.of((Object)builder, (Object)blockType));
        this.blockTypes.add(blockType);
    }

    public List<Pair<RechiseledBlockBuilderImpl, RechiseledBlockTypeImpl>> getBlockBuilders() {
        return this.blockBuilders;
    }

    public List<Triple<class_2960, Supplier<class_1935>, Supplier<class_1935>>> getChiselingEntries() {
        return this.chiselingEntries;
    }

    public CreativeItemGroup getItemGroup() {
        return this.itemGroup;
    }

    public String getItemGroupTranslation() {
        return this.itemGroupTranslation;
    }
}

