/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.core.item;

import com.supermartijn642.core.item.ItemRarity;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.class_1761;
import net.minecraft.class_1792;
import net.minecraft.class_1814;
import net.minecraft.class_4174;

public class ItemProperties {
    private int maxStackSize = 64;
    private int durability;
    private class_1792 craftingRemainingItem;
    private class_1814 rarity = class_1814.field_8906;
    private class_4174 foodProperties;
    private boolean isFireResistant;
    final Set<class_1761> groups = new HashSet<class_1761>();

    public static ItemProperties create() {
        return new ItemProperties();
    }

    private ItemProperties() {
    }

    public ItemProperties maxStackSize(int maxStackSize) {
        if (maxStackSize < 1) {
            throw new IllegalArgumentException("Maximum stack size must be greater than zero!");
        }
        if (maxStackSize > 1 && this.durability != 0) {
            throw new RuntimeException("An item cannot have durability and be stackable!");
        }
        this.maxStackSize = maxStackSize;
        return this;
    }

    public ItemProperties durability(int durability) {
        if (this.maxStackSize != 64 && this.maxStackSize > 1) {
            throw new RuntimeException("An item cannot have durability and be stackable!");
        }
        this.durability = durability;
        this.maxStackSize = 1;
        return this;
    }

    public ItemProperties craftRemainder(class_1792 item) {
        this.craftingRemainingItem = item;
        return this;
    }

    public ItemProperties group(class_1761 group) {
        this.groups.add(group);
        return this;
    }

    public ItemProperties rarity(class_1814 rarity) {
        this.rarity = rarity;
        return this;
    }

    public ItemProperties rarity(ItemRarity rarity) {
        this.rarity = rarity.getUnderlying();
        return this;
    }

    public ItemProperties food(class_4174 foodProperties) {
        this.foodProperties = foodProperties;
        return this;
    }

    public ItemProperties fireResistant() {
        this.isFireResistant = true;
        return this;
    }

    @Deprecated
    public class_1792.class_1793 toUnderlying() {
        class_1792.class_1793 properties = new class_1792.class_1793();
        properties.method_7889(this.maxStackSize);
        if (this.durability != 0) {
            properties.method_7895(this.durability);
        }
        properties.method_7896(this.craftingRemainingItem);
        properties.method_7894(this.rarity);
        properties.method_19265(this.foodProperties);
        if (this.isFireResistant) {
            properties.method_24359();
        }
        return properties;
    }
}

