/*
 * Decompiled with CFR 0.152.
 */
package org.mtr.mod.screen;

import java.util.Collections;
import net.minecraft.class_2960;
import org.mtr.core.tool.Utilities;
import org.mtr.libraries.it.unimi.dsi.fastutil.longs.LongAVLTreeSet;
import org.mtr.libraries.it.unimi.dsi.fastutil.objects.ObjectArrayList;
import org.mtr.libraries.it.unimi.dsi.fastutil.objects.ObjectObjectImmutablePair;
import org.mtr.mapping.holder.BlockPos;
import org.mtr.mapping.holder.ClientWorld;
import org.mtr.mapping.holder.Identifier;
import org.mtr.mapping.holder.MinecraftClient;
import org.mtr.mapping.holder.MutableText;
import org.mtr.mapping.holder.SoundCategory;
import org.mtr.mapping.mapper.AbstractSoundInstanceExtension;
import org.mtr.mapping.mapper.GraphicsHolder;
import org.mtr.mapping.mapper.GuiDrawing;
import org.mtr.mapping.mapper.SoundHelper;
import org.mtr.mapping.mapper.TextFieldWidgetExtension;
import org.mtr.mapping.tool.TextCase;
import org.mtr.mod.InitClient;
import org.mtr.mod.block.BlockTrainAnnouncer;
import org.mtr.mod.generated.lang.TranslationProvider;
import org.mtr.mod.packet.PacketUpdateTrainAnnouncerConfig;
import org.mtr.mod.resource.CustomResourceTools;
import org.mtr.mod.screen.DashboardList;
import org.mtr.mod.screen.DashboardListItem;
import org.mtr.mod.screen.TrainSensorScreenBase;

public class TrainAnnouncerScreen
extends TrainSensorScreenBase {
    private final String initialMessage;
    private final String initialSoundId;
    private final int initialDelay;
    private final DashboardList availableSoundsList;
    private static final int MAX_MESSAGE_LENGTH = 256;
    private static final int MAX_DELAY_LENGTH = 3;

    public TrainAnnouncerScreen(BlockPos pos, BlockTrainAnnouncer.BlockEntity blockEntity) {
        super(pos, true, new ObjectObjectImmutablePair<TextFieldWidgetExtension, MutableText>(new TextFieldWidgetExtension(0, 0, 0, 20, 256, TextCase.DEFAULT, null, null), TranslationProvider.GUI_MTR_ANNOUNCEMENT_MESSAGE.getMutableText(new Object[0])), new ObjectObjectImmutablePair<TextFieldWidgetExtension, MutableText>(new TextFieldWidgetExtension(0, 0, 0, 20, 256, TextCase.DEFAULT, null, null), TranslationProvider.GUI_MTR_SOUND_FILE.getMutableText(new Object[0])), new ObjectObjectImmutablePair<TextFieldWidgetExtension, MutableText>(new TextFieldWidgetExtension(0, 0, 0, 20, 3, TextCase.DEFAULT, "\\D", null), TranslationProvider.GUI_MTR_ANNOUNCEMENT_DELAY.getMutableText(new Object[0])));
        ClientWorld clientWorld = MinecraftClient.getInstance().getWorldMapped();
        if (clientWorld != null) {
            this.initialMessage = blockEntity.getMessage();
            this.initialSoundId = blockEntity.getSoundId();
            this.initialDelay = blockEntity.getDelay();
        } else {
            this.initialMessage = "";
            this.initialSoundId = "";
            this.initialDelay = 0;
        }
        this.availableSoundsList = new DashboardList((data, color) -> {
            String soundId = CustomResourceTools.formatIdentifierString(data.getName(true));
            if (!soundId.isEmpty() && clientWorld != null && MinecraftClient.getInstance().getPlayerMapped() != null) {
                clientWorld.playSoundAtBlockCenter(pos, SoundHelper.createSoundEvent(new Identifier(soundId)), SoundCategory.BLOCKS, 1000000.0f, 1.0f, false);
            }
        }, null, null, null, (data, color) -> {
            this.textFields[1].setText2(data.getName(true));
            this.setListVisibility(false);
        }, null, null, () -> "", text -> {}, false);
        ObjectArrayList<DashboardListItem> soundIds = new ObjectArrayList<DashboardListItem>();
        AbstractSoundInstanceExtension.iterateSoundIds(identifier -> soundIds.add(new DashboardListItem(0L, ((class_2960)identifier.data).toString(), -15592942)));
        Collections.sort(soundIds);
        this.availableSoundsList.setData(soundIds, true, false, false, false, true, false);
    }

    @Override
    protected void init2() {
        super.init2();
        this.textFields[0].setText2(this.initialMessage);
        this.textFields[1].setText2(this.initialSoundId);
        this.textFields[2].setText2(String.valueOf(this.initialDelay));
        this.setListVisibility(false);
        this.availableSoundsList.y = 58;
        this.availableSoundsList.height = this.field_22790 - this.availableSoundsList.y - 20;
        this.availableSoundsList.width = (this.field_22789 - 40) * 2 / 3;
        this.availableSoundsList.init(this::addChild);
    }

    @Override
    public void tick2() {
        super.tick2();
        this.availableSoundsList.tick();
    }

    @Override
    public boolean mouseClicked2(double mouseX, double mouseY, int button) {
        if (button == 0) {
            if (Utilities.isBetween(mouseX, this.textFields[1].getX2(), this.textFields[1].getX2() + this.textFields[1].getWidth2()) && Utilities.isBetween(mouseY, this.textFields[1].getY2(), this.textFields[1].getY2() + this.textFields[1].getHeight2())) {
                this.setListVisibility(true);
            } else if (!Utilities.isBetween(mouseX, this.availableSoundsList.x, this.availableSoundsList.x + this.availableSoundsList.width) || !Utilities.isBetween(mouseY, this.availableSoundsList.y, this.availableSoundsList.y + this.availableSoundsList.height)) {
                this.setListVisibility(false);
            }
        }
        return super.mouseClicked2(mouseX, mouseY, button);
    }

    @Override
    public void mouseMoved2(double mouseX, double mouseY) {
        this.availableSoundsList.mouseMoved(mouseX, mouseY);
    }

    @Override
    public boolean mouseScrolled2(double mouseX, double mouseY, double amount) {
        this.availableSoundsList.mouseScrolled(mouseX, mouseY, amount);
        return super.mouseScrolled2(mouseX, mouseY, amount);
    }

    @Override
    protected void renderAdditional(GraphicsHolder graphicsHolder) {
        GuiDrawing guiDrawing = new GuiDrawing(graphicsHolder);
        guiDrawing.beginDrawingRectangle();
        guiDrawing.drawRectangle(this.availableSoundsList.x, this.availableSoundsList.y, this.availableSoundsList.x + this.availableSoundsList.width, this.availableSoundsList.y + this.availableSoundsList.height, -15592942);
        guiDrawing.finishDrawingRectangle();
        this.availableSoundsList.render(graphicsHolder);
    }

    @Override
    protected void sendUpdate(BlockPos blockPos, LongAVLTreeSet filterRouteIds, boolean stoppedOnly, boolean movingOnly) {
        int delay = 0;
        try {
            delay = Integer.parseInt(this.textFields[2].getText2());
        }
        catch (Exception exception) {
            // empty catch block
        }
        InitClient.REGISTRY_CLIENT.sendPacketToServer(new PacketUpdateTrainAnnouncerConfig(blockPos, filterRouteIds, stoppedOnly, movingOnly, this.textFields[0].getText2(), this.textFields[1].getText2(), delay));
    }

    private void setListVisibility(boolean visible) {
        this.availableSoundsList.x = visible ? (this.field_22789 - 40) / 3 + 20 : this.field_22789;
    }
}

