/*
 * Decompiled with CFR 0.152.
 */
package org.mtr.mod.resource;

import javax.annotation.Nullable;
import net.minecraft.class_2960;
import org.mtr.core.serializer.ReaderBase;
import org.mtr.core.tool.Utilities;
import org.mtr.libraries.it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import org.mtr.libraries.it.unimi.dsi.fastutil.objects.ObjectArrayList;
import org.mtr.libraries.it.unimi.dsi.fastutil.objects.ObjectObjectImmutablePair;
import org.mtr.mapping.holder.Identifier;
import org.mtr.mod.Init;
import org.mtr.mod.client.CustomResourceLoader;
import org.mtr.mod.generated.resource.VehicleModelWrapperSchema;
import org.mtr.mod.resource.ModelProperties;
import org.mtr.mod.resource.ModelPropertiesPart;
import org.mtr.mod.resource.ModelPropertiesPartWrapper;
import org.mtr.mod.resource.PositionDefinition;
import org.mtr.mod.resource.PositionDefinitions;
import org.mtr.mod.resource.ResourceProvider;
import org.mtr.mod.resource.VehicleModel;

public final class VehicleModelWrapper
extends VehicleModelWrapperSchema {
    VehicleModelWrapper(String modelResource, String textureResource, String minecraftModelPropertiesResource, String minecraftPositionDefinitionsResource, boolean flipTextureV, ObjectArrayList<ModelPropertiesPartWrapper> parts, double modelYOffset, String gangwayInnerSideResource, String gangwayInnerTopResource, String gangwayInnerBottomResource, String gangwayOuterSideResource, String gangwayOuterTopResource, String gangwayOuterBottomResource, double gangwayWidth, double gangwayHeight, double gangwayYOffset, double gangwayZOffset, String barrierInnerSideResource, String barrierInnerTopResource, String barrierInnerBottomResource, String barrierOuterSideResource, String barrierOuterTopResource, String barrierOuterBottomResource, double barrierWidth, double barrierHeight, double barrierYOffset, double barrierZOffset) {
        super(modelResource, textureResource, minecraftModelPropertiesResource, minecraftPositionDefinitionsResource, flipTextureV, modelYOffset, gangwayInnerSideResource, gangwayInnerTopResource, gangwayInnerBottomResource, gangwayOuterSideResource, gangwayOuterTopResource, gangwayOuterBottomResource, gangwayWidth, gangwayHeight, gangwayYOffset, gangwayZOffset, barrierInnerSideResource, barrierInnerTopResource, barrierInnerBottomResource, barrierOuterSideResource, barrierOuterTopResource, barrierOuterBottomResource, barrierWidth, barrierHeight, barrierYOffset, barrierZOffset);
        this.parts.addAll(parts);
    }

    public VehicleModelWrapper(ReaderBase readerBase) {
        super(readerBase);
        this.updateData(readerBase);
    }

    VehicleModel toVehicleModel(ResourceProvider resourceProvider, @Nullable Object2ObjectArrayMap<String, ModelProperties> modelPropertiesMap, @Nullable Object2ObjectArrayMap<String, PositionDefinitions> positionDefinitionsMap) {
        ObjectArrayList<ModelPropertiesPart> modelPropertiesPartList = new ObjectArrayList<ModelPropertiesPart>();
        ObjectArrayList<PositionDefinition> positionDefinitionList = new ObjectArrayList<PositionDefinition>();
        this.parts.forEach(part -> {
            ObjectObjectImmutablePair<ModelPropertiesPart, PositionDefinition> modelPropertiesPartAndPositionDefinition = part.toModelPropertiesPartAndPositionDefinition();
            modelPropertiesPartList.add(modelPropertiesPartAndPositionDefinition.left());
            positionDefinitionList.add(modelPropertiesPartAndPositionDefinition.right());
        });
        boolean isMinecraftResource = CustomResourceLoader.getMinecraftModelResources().stream().anyMatch(minecraftModelResource -> minecraftModelResource.matchesModelResource(this.modelResource));
        String modelPropertiesResource = isMinecraftResource ? this.minecraftModelPropertiesResource : ((class_2960)new Identifier((String)"mtr", (String)String.format((String)"properties_%s.json", (Object[])new Object[]{Init.randomString()})).data).toString();
        ModelProperties modelProperties = new ModelProperties(modelPropertiesPartList, this.modelYOffset, this.gangwayInnerSideResource, this.gangwayInnerTopResource, this.gangwayInnerBottomResource, this.gangwayOuterSideResource, this.gangwayOuterTopResource, this.gangwayOuterBottomResource, this.gangwayWidth, this.gangwayHeight, this.gangwayYOffset, this.gangwayZOffset, this.barrierInnerSideResource, this.barrierInnerTopResource, this.barrierInnerBottomResource, this.barrierOuterSideResource, this.barrierOuterTopResource, this.barrierOuterBottomResource, this.barrierWidth, this.barrierHeight, this.barrierYOffset, this.barrierZOffset);
        String positionDefinitionsResource = isMinecraftResource ? this.minecraftPositionDefinitionsResource : ((class_2960)new Identifier((String)"mtr", (String)String.format((String)"definition_%s.json", (Object[])new Object[]{Init.randomString()})).data).toString();
        PositionDefinitions positionDefinitions = new PositionDefinitions(positionDefinitionList);
        if (!isMinecraftResource && modelPropertiesMap != null && positionDefinitionsMap != null) {
            modelPropertiesMap.put(modelPropertiesResource, modelProperties);
            positionDefinitionsMap.put(positionDefinitionsResource, positionDefinitions);
        }
        return new VehicleModel(this.modelResource, this.textureResource, modelPropertiesResource, positionDefinitionsResource, this.flipTextureV, identifier -> {
            String identifierString = ((class_2960)identifier.data).toString();
            if (!isMinecraftResource) {
                if (identifierString.equals(modelPropertiesResource)) {
                    return Utilities.getJsonObjectFromData(modelProperties).toString();
                }
                if (identifierString.equals(positionDefinitionsResource)) {
                    return Utilities.getJsonObjectFromData(positionDefinitions).toString();
                }
                return resourceProvider.get(identifier);
            }
            return resourceProvider.get(identifier);
        });
    }

    void clean() {
        this.parts.removeIf(modelPropertiesPartWrapper -> modelPropertiesPartWrapper.getName().isEmpty());
    }
}

