/*
 * Decompiled with CFR 0.152.
 */
package org.mtr.mod.render;

import java.util.Comparator;
import net.minecraft.class_2382;
import org.mtr.core.data.Lift;
import org.mtr.core.data.LiftDirection;
import org.mtr.libraries.it.unimi.dsi.fastutil.objects.ObjectArrayList;
import org.mtr.libraries.it.unimi.dsi.fastutil.objects.ObjectArraySet;
import org.mtr.libraries.it.unimi.dsi.fastutil.objects.ObjectObjectImmutablePair;
import org.mtr.mapping.holder.Block;
import org.mtr.mapping.holder.BlockPos;
import org.mtr.mapping.holder.BlockState;
import org.mtr.mapping.holder.ClientPlayerEntity;
import org.mtr.mapping.holder.Direction;
import org.mtr.mapping.holder.HitResult;
import org.mtr.mapping.holder.Identifier;
import org.mtr.mapping.holder.Item;
import org.mtr.mapping.holder.MathHelper;
import org.mtr.mapping.holder.MinecraftClient;
import org.mtr.mapping.holder.PlayerEntity;
import org.mtr.mapping.holder.Vector3d;
import org.mtr.mapping.holder.Vector3i;
import org.mtr.mapping.holder.World;
import org.mtr.mapping.mapper.BlockEntityRenderer;
import org.mtr.mapping.mapper.DirectionHelper;
import org.mtr.mapping.mapper.GraphicsHolder;
import org.mtr.mapping.mapper.PlayerHelper;
import org.mtr.mod.Init;
import org.mtr.mod.block.BlockLiftButtons;
import org.mtr.mod.block.BlockLiftTrackFloor;
import org.mtr.mod.block.IBlock;
import org.mtr.mod.client.IDrawing;
import org.mtr.mod.data.IGui;
import org.mtr.mod.item.ItemLiftButtonsLinkModifier;
import org.mtr.mod.render.MainRenderer;
import org.mtr.mod.render.QueuedRenderLayer;
import org.mtr.mod.render.RenderLifts;
import org.mtr.mod.render.StoredMatrixTransformations;

public class RenderLiftButtons
extends BlockEntityRenderer<BlockLiftButtons.BlockEntity>
implements DirectionHelper,
IGui,
IBlock {
    private static final int HOVER_COLOR = -21846;
    private static final int PRESSED_COLOR = -65536;
    private static final Identifier BUTTON_TEXTURE = new Identifier("mtr", "textures/block/lift_button.png");

    public RenderLiftButtons(BlockEntityRenderer.Argument dispatcher) {
        super(dispatcher);
    }

    @Override
    public void render(BlockLiftButtons.BlockEntity blockEntity, float tickDelta, GraphicsHolder graphicsHolder1, int light, int overlay) {
        boolean lookingAtBottomHalf;
        boolean lookingAtTopHalf;
        World world = blockEntity.getWorld2();
        if (world == null) {
            return;
        }
        ClientPlayerEntity clientPlayerEntity = MinecraftClient.getInstance().getPlayerMapped();
        if (clientPlayerEntity == null) {
            return;
        }
        BlockPos blockPos = blockEntity.getPos2();
        BlockState blockState = world.getBlockState(blockPos);
        Direction facing = IBlock.getStatePropertySafe(blockState, FACING);
        boolean holdingLinker = PlayerHelper.isHolding(PlayerEntity.cast(clientPlayerEntity), item -> item.data instanceof ItemLiftButtonsLinkModifier || Block.getBlockFromItem((Item)item).data instanceof BlockLiftButtons);
        StoredMatrixTransformations storedMatrixTransformations1 = new StoredMatrixTransformations((double)blockPos.getX() + 0.5, blockPos.getY(), (double)blockPos.getZ() + 0.5);
        boolean[] buttonStates = new boolean[]{false, false, false, false};
        ObjectArrayList<ObjectObjectImmutablePair> sortedPositionsAndLifts = new ObjectArrayList<ObjectObjectImmutablePair>();
        blockEntity.forEachTrackPosition(trackPosition -> {
            if (world.getBlockState((BlockPos)trackPosition).getBlock().data instanceof BlockLiftTrackFloor) {
                Direction trackFacing = IBlock.getStatePropertySafe(world, trackPosition, FACING);
                RenderLiftButtons.renderLiftObjectLink(storedMatrixTransformations1, world, new Vector3d((float)facing.getOffsetX() / 2.0f, 0.5, (float)facing.getOffsetZ() / 2.0f), new Vector3d((float)(trackPosition.getX() - blockPos.getX()) + (float)trackFacing.getOffsetX() / 2.0f, (double)(trackPosition.getY() - blockPos.getY()) + 0.5, (float)(trackPosition.getZ() - blockPos.getZ()) + (float)trackFacing.getOffsetZ() / 2.0f), holdingLinker);
            }
            BlockLiftButtons.hasButtonsClient(trackPosition, buttonStates, (floorIndex, lift) -> {
                sortedPositionsAndLifts.add(new ObjectObjectImmutablePair<BlockPos, Lift>((BlockPos)trackPosition, lift));
                ObjectArraySet<LiftDirection> instructionDirections = lift.hasInstruction(floorIndex);
                instructionDirections.forEach(liftDirection -> {
                    switch (liftDirection) {
                        case DOWN: {
                            buttonStates[2] = true;
                            break;
                        }
                        case UP: {
                            buttonStates[3] = true;
                        }
                    }
                });
            });
        });
        sortedPositionsAndLifts.sort(Comparator.comparingInt(sortedPositionAndLift -> blockPos.getManhattanDistance(new Vector3i((class_2382)((BlockPos)sortedPositionAndLift.left()).data))));
        HitResult hitResult = MinecraftClient.getInstance().getCrosshairTargetMapped();
        if (clientPlayerEntity.isSpectator() || hitResult == null || !IBlock.getStatePropertySafe(blockState, BlockLiftButtons.UNLOCKED)) {
            lookingAtTopHalf = false;
            lookingAtBottomHalf = false;
        } else {
            Vector3d hitLocation = hitResult.getPos();
            double hitY = MathHelper.fractionalPart(hitLocation.getYMapped());
            boolean inBlock = hitY < 0.5 && Init.newBlockPos(hitLocation.getXMapped(), hitLocation.getYMapped(), hitLocation.getZMapped()).equals(blockPos);
            lookingAtTopHalf = inBlock && (!buttonStates[0] || hitY > 0.25);
            lookingAtBottomHalf = inBlock && (!buttonStates[1] || hitY < 0.25);
        }
        StoredMatrixTransformations storedMatrixTransformations2 = storedMatrixTransformations1.copy();
        storedMatrixTransformations2.add(graphicsHolder -> {
            graphicsHolder.rotateYDegrees(-facing.asRotation());
            graphicsHolder.translate(0.0, 0.0, 0.43437499995343387);
        });
        if (buttonStates[0]) {
            MainRenderer.scheduleRender(BUTTON_TEXTURE, false, buttonStates[2] || lookingAtBottomHalf ? QueuedRenderLayer.LIGHT_TRANSLUCENT : QueuedRenderLayer.EXTERIOR, (graphicsHolder, offset) -> {
                storedMatrixTransformations2.transform((GraphicsHolder)graphicsHolder, (Vector3d)offset);
                IDrawing.drawTexture(graphicsHolder, -0.09375f, (buttonStates[1] ? 0.5f : 2.5f) / 16.0f, 0.1875f, 0.1875f, 0.0f, 0.0f, 1.0f, 1.0f, facing, buttonStates[2] ? -65536 : (lookingAtBottomHalf ? -21846 : -10066330), light);
                graphicsHolder.pop();
            });
        }
        if (buttonStates[1]) {
            MainRenderer.scheduleRender(BUTTON_TEXTURE, false, buttonStates[3] || lookingAtTopHalf ? QueuedRenderLayer.LIGHT_TRANSLUCENT : QueuedRenderLayer.EXTERIOR, (graphicsHolder, offset) -> {
                storedMatrixTransformations2.transform((GraphicsHolder)graphicsHolder, (Vector3d)offset);
                IDrawing.drawTexture(graphicsHolder, -0.09375f, (buttonStates[0] ? 4.5f : 2.5f) / 16.0f, 0.1875f, 0.1875f, 0.0f, 1.0f, 1.0f, 0.0f, facing, buttonStates[3] ? -65536 : (lookingAtTopHalf ? -21846 : -10066330), light);
                graphicsHolder.pop();
            });
        }
        if (!sortedPositionsAndLifts.isEmpty()) {
            int count = Math.min(2, sortedPositionsAndLifts.size());
            float width = count == 1 ? 0.25f : 0.375f;
            StoredMatrixTransformations storedMatrixTransformations3 = storedMatrixTransformations2.copy();
            storedMatrixTransformations3.add(graphicsHolder -> {
                graphicsHolder.rotateZDegrees(180.0f);
                graphicsHolder.translate(-width / 2.0f, 0.0, 0.0);
            });
            MainRenderer.scheduleRender(new Identifier("mtr", "textures/block/black.png"), false, QueuedRenderLayer.EXTERIOR, (graphicsHolder, offset) -> {
                storedMatrixTransformations3.transform((GraphicsHolder)graphicsHolder, (Vector3d)offset);
                IDrawing.drawTexture(graphicsHolder, 0.0f, -0.9375f, width, 0.40625f, Direction.UP, light);
                graphicsHolder.pop();
            });
            boolean reverseRendering = count > 1 && RenderLiftButtons.reverseRendering(facing.rotateYCounterclockwise(), (BlockPos)((ObjectObjectImmutablePair)sortedPositionsAndLifts.get(0)).left(), (BlockPos)((ObjectObjectImmutablePair)sortedPositionsAndLifts.get(1)).left());
            for (int i = 0; i < count; ++i) {
                double x = ((double)(reverseRendering ? count - i - 1 : i) + 0.5) * (double)width / (double)count;
                StoredMatrixTransformations storedMatrixTransformations4 = storedMatrixTransformations3.copy();
                storedMatrixTransformations4.add(graphicsHolder -> graphicsHolder.translate(x, -0.875, -0.003125f));
                RenderLifts.renderLiftDisplay(storedMatrixTransformations4, world, (Lift)((ObjectObjectImmutablePair)sortedPositionsAndLifts.get(i)).right(), width / (float)count, 0.3125f);
            }
        }
    }

    public static void renderLiftObjectLink(StoredMatrixTransformations storedMatrixTransformations, World world, Vector3d position1, Vector3d position2, boolean holdingLinker) {
        if (holdingLinker) {
            MainRenderer.scheduleRender(QueuedRenderLayer.LINES, (graphicsHolder, offset) -> {
                storedMatrixTransformations.transform((GraphicsHolder)graphicsHolder, (Vector3d)offset);
                graphicsHolder.drawLineInWorld((float)position1.getXMapped(), (float)position1.getYMapped(), (float)position1.getZMapped(), (float)position2.getXMapped(), (float)position2.getYMapped(), (float)position2.getZMapped(), -1);
                graphicsHolder.pop();
            });
        }
    }

    private static boolean reverseRendering(Direction direction, BlockPos blockPos1, BlockPos blockPos2) {
        if (direction.getOffsetX() != 0) {
            return Math.signum(blockPos2.getX() - blockPos1.getX()) == (float)direction.getOffsetX();
        }
        if (direction.getOffsetZ() != 0) {
            return Math.signum(blockPos2.getZ() - blockPos1.getZ()) == (float)direction.getOffsetZ();
        }
        return false;
    }
}

