/*
 * Decompiled with CFR 0.152.
 */
package org.mtr.mod.packet;

import net.minecraft.class_1937;
import org.mtr.mapping.holder.Block;
import org.mtr.mapping.holder.BlockPos;
import org.mtr.mapping.holder.BlockState;
import org.mtr.mapping.holder.MinecraftServer;
import org.mtr.mapping.holder.ServerPlayerEntity;
import org.mtr.mapping.holder.World;
import org.mtr.mapping.registry.PacketHandler;
import org.mtr.mapping.tool.PacketBufferReceiver;
import org.mtr.mapping.tool.PacketBufferSender;
import org.mtr.mod.Init;
import org.mtr.mod.block.BlockSignalBase;
import org.mtr.mod.block.BlockTrainPoweredSensorBase;

public final class PacketTurnOnBlockEntity
extends PacketHandler {
    private final BlockPos blockPos;
    private final int level;

    public PacketTurnOnBlockEntity(PacketBufferReceiver packetBufferReceiver) {
        this.blockPos = BlockPos.fromLong(packetBufferReceiver.readLong());
        this.level = packetBufferReceiver.readInt();
    }

    public PacketTurnOnBlockEntity(BlockPos blockPos) {
        this(blockPos, 0);
    }

    public PacketTurnOnBlockEntity(BlockPos blockPos, int level) {
        this.blockPos = blockPos;
        this.level = level;
    }

    @Override
    public void write(PacketBufferSender packetBufferSender) {
        packetBufferSender.writeLong(this.blockPos.asLong());
        packetBufferSender.writeInt(this.level);
    }

    @Override
    public void runServer(MinecraftServer minecraftServer, ServerPlayerEntity serverPlayerEntity) {
        World world = new World((class_1937)serverPlayerEntity.getServerWorld().data);
        if (!Init.isChunkLoaded(world, this.blockPos)) {
            return;
        }
        BlockState blockState = world.getBlockState(this.blockPos);
        Block block = blockState.getBlock();
        if (block.data instanceof BlockTrainPoweredSensorBase) {
            ((BlockTrainPoweredSensorBase)block.data).power(world, blockState, this.blockPos);
        }
        if (block.data instanceof BlockSignalBase) {
            ((BlockSignalBase)block.data).power(world, blockState, this.blockPos, this.level);
        }
    }
}

