/*
 * Decompiled with CFR 0.152.
 */
package org.mtr.mod.item;

import org.mtr.mapping.holder.Block;
import org.mtr.mapping.holder.BlockEntity;
import org.mtr.mapping.holder.BlockPos;
import org.mtr.mapping.holder.CompoundTag;
import org.mtr.mapping.holder.ItemSettings;
import org.mtr.mapping.holder.ItemUsageContext;
import org.mtr.mapping.holder.World;
import org.mtr.mod.block.BlockLiftButtons;
import org.mtr.mod.block.BlockLiftPanelBase;
import org.mtr.mod.block.BlockLiftTrackFloor;
import org.mtr.mod.item.ItemBlockClickingBase;

public class ItemLiftButtonsLinkModifier
extends ItemBlockClickingBase {
    private final boolean isConnector;

    public ItemLiftButtonsLinkModifier(boolean isConnector, ItemSettings itemSettings) {
        super(itemSettings.maxCount(1));
        this.isConnector = isConnector;
    }

    @Override
    protected void onStartClick(ItemUsageContext context, CompoundTag compoundTag) {
    }

    @Override
    protected void onEndClick(ItemUsageContext context, BlockPos posEnd, CompoundTag compoundTag) {
        World world = context.getWorld();
        BlockPos posStart = context.getBlockPos();
        ItemLiftButtonsLinkModifier.connect(world, posStart, posEnd, this.isConnector);
        ItemLiftButtonsLinkModifier.connect(world, posEnd, posStart, this.isConnector);
    }

    @Override
    protected boolean clickCondition(ItemUsageContext context) {
        Block block = context.getWorld().getBlockState(context.getBlockPos()).getBlock();
        return block.data instanceof BlockLiftTrackFloor || block.data instanceof BlockLiftButtons || block.data instanceof BlockLiftPanelBase;
    }

    private static void connect(World world, BlockPos blockPos1, BlockPos blockPos2, boolean isAdd) {
        BlockEntity blockEntity1 = world.getBlockEntity(blockPos1);
        BlockEntity blockEntity2 = world.getBlockEntity(blockPos2);
        if (blockEntity1 != null && blockEntity2 != null && blockEntity2.data instanceof BlockLiftTrackFloor.BlockEntity) {
            if (blockEntity1.data instanceof BlockLiftButtons.BlockEntity) {
                ((BlockLiftButtons.BlockEntity)((Object)blockEntity1.data)).registerFloor(blockPos2, isAdd);
            }
            if (blockEntity1.data instanceof BlockLiftPanelBase.BlockEntityBase) {
                ((BlockLiftPanelBase.BlockEntityBase)((Object)blockEntity1.data)).registerFloor(world, blockPos2, isAdd);
            }
        }
    }
}

