/*
 * Decompiled with CFR 0.152.
 */
package org.mtr.mod.item;

import java.util.Comparator;
import javax.annotation.Nullable;
import org.mtr.core.data.AreaBase;
import org.mtr.core.data.ClientData;
import org.mtr.core.data.Data;
import org.mtr.core.data.Depot;
import org.mtr.core.data.Platform;
import org.mtr.core.data.Position;
import org.mtr.core.data.SavedRailBase;
import org.mtr.core.data.Siding;
import org.mtr.core.data.Station;
import org.mtr.core.data.TransportMode;
import org.mtr.core.operation.DataRequest;
import org.mtr.core.operation.DataResponse;
import org.mtr.core.serializer.JsonReader;
import org.mtr.core.tool.Utilities;
import org.mtr.libraries.it.unimi.dsi.fastutil.objects.ObjectArraySet;
import org.mtr.mapping.holder.Hand;
import org.mtr.mapping.holder.ItemSettings;
import org.mtr.mapping.holder.PlayerEntity;
import org.mtr.mapping.holder.ServerPlayerEntity;
import org.mtr.mapping.holder.ServerWorld;
import org.mtr.mapping.holder.World;
import org.mtr.mapping.mapper.ItemExtension;
import org.mtr.mod.Init;
import org.mtr.mod.Keys;
import org.mtr.mod.client.CustomResourceLoader;
import org.mtr.mod.packet.PacketOpenDashboardScreen;

public class ItemDashboard
extends ItemExtension {
    private final TransportMode transportMode;
    private static final int SEARCH_RADIUS = 5;

    public ItemDashboard(TransportMode transportMode, ItemSettings itemSettings) {
        super(itemSettings.maxCount(1));
        this.transportMode = transportMode;
    }

    @Override
    public void useWithoutResult(World world, PlayerEntity user, Hand hand) {
        if (Keys.DEBUG && user.isSneaking()) {
            if (world.isClient()) {
                CustomResourceLoader.reload();
            }
        } else if (!world.isClient()) {
            if (user.isSneaking()) {
                Position playerPosition = Init.blockPosToPosition(user.getBlockPos());
                Init.sendMessageC2S("get_data", world.getServer(), world, new DataRequest(user.getUuid(), playerPosition, 5L), dataResponse -> {
                    ClientData tempClientData = new ClientData();
                    new DataResponse(new JsonReader(Utilities.getJsonObjectFromData(dataResponse)), tempClientData).write();
                    Station station = (Station)ItemDashboard.findNearbyArea(playerPosition, tempClientData.stations);
                    Depot depot = (Depot)ItemDashboard.findNearbyArea(playerPosition, tempClientData.depots);
                    if (station != null) {
                        Platform platform = (Platform)ItemDashboard.findNearbySavedRail(playerPosition, station.savedRails, tempClientData);
                        if (platform == null) {
                            PacketOpenDashboardScreen.sendDirectlyToServer(ServerWorld.cast(world), ServerPlayerEntity.cast(user), this.transportMode, PacketOpenDashboardScreen.ScreenType.STATION, station.getId());
                        } else {
                            PacketOpenDashboardScreen.sendDirectlyToServer(ServerWorld.cast(world), ServerPlayerEntity.cast(user), this.transportMode, PacketOpenDashboardScreen.ScreenType.PLATFORM, platform.getId());
                        }
                    } else if (depot != null) {
                        Siding siding = (Siding)ItemDashboard.findNearbySavedRail(playerPosition, depot.savedRails, tempClientData);
                        if (siding == null) {
                            PacketOpenDashboardScreen.sendDirectlyToServer(ServerWorld.cast(world), ServerPlayerEntity.cast(user), this.transportMode, PacketOpenDashboardScreen.ScreenType.DEPOT, depot.getId());
                        } else {
                            PacketOpenDashboardScreen.sendDirectlyToServer(ServerWorld.cast(world), ServerPlayerEntity.cast(user), this.transportMode, PacketOpenDashboardScreen.ScreenType.SIDING, siding.getId());
                        }
                    } else {
                        PacketOpenDashboardScreen.sendDirectlyToServer(ServerWorld.cast(world), ServerPlayerEntity.cast(user), this.transportMode);
                    }
                }, DataResponse.class);
            } else {
                PacketOpenDashboardScreen.sendDirectlyToServer(ServerWorld.cast(world), ServerPlayerEntity.cast(user), this.transportMode);
            }
        }
    }

    @Nullable
    private static <T extends AreaBase<T, U>, U extends SavedRailBase<U, T>> T findNearbyArea(Position position, ObjectArraySet<T> areas) {
        return (T)((AreaBase)areas.stream().filter(area -> area.inArea(position)).findFirst().orElse(null));
    }

    @Nullable
    private static <T extends SavedRailBase<T, U>, U extends AreaBase<U, T>> T findNearbySavedRail(Position position, ObjectArraySet<T> rails, Data data) {
        return (T)((SavedRailBase)rails.stream().filter(rail -> rail.closeTo(position, 5.0)).min(Comparator.comparingDouble(rail -> rail.getApproximateClosestDistance(position, data))).orElse(null));
    }
}

