/*
 * Decompiled with CFR 0.152.
 */
package org.mtr.mod.client;

import com.mojang.text2speech.Narrator;
import javax.annotation.Nullable;
import net.minecraft.class_2561;
import org.mtr.libraries.it.unimi.dsi.fastutil.booleans.BooleanArrayList;
import org.mtr.libraries.it.unimi.dsi.fastutil.objects.ObjectArrayList;
import org.mtr.mapping.holder.ClientPlayerEntity;
import org.mtr.mapping.holder.Direction;
import org.mtr.mapping.holder.Identifier;
import org.mtr.mapping.holder.LightmapTextureManager;
import org.mtr.mapping.holder.MathHelper;
import org.mtr.mapping.holder.MinecraftClient;
import org.mtr.mapping.holder.MutableText;
import org.mtr.mapping.holder.OrderedText;
import org.mtr.mapping.holder.Style;
import org.mtr.mapping.holder.Text;
import org.mtr.mapping.holder.Vector3d;
import org.mtr.mapping.mapper.ButtonWidgetExtension;
import org.mtr.mapping.mapper.CheckboxWidgetExtension;
import org.mtr.mapping.mapper.GraphicsHolder;
import org.mtr.mapping.mapper.SliderWidgetExtension;
import org.mtr.mapping.mapper.TextFieldWidgetExtension;
import org.mtr.mapping.mapper.TextHelper;
import org.mtr.mapping.mapper.TexturedButtonWidgetExtension;
import org.mtr.mod.config.Config;
import org.mtr.mod.data.IGui;

public interface IDrawing {
    public static void drawStringWithFont(GraphicsHolder graphicsHolder, String text, float x, float y, int light) {
        IDrawing.drawStringWithFont(graphicsHolder, text, IGui.HorizontalAlignment.CENTER, IGui.VerticalAlignment.CENTER, x, y, -1.0f, -1.0f, 1.0f, -1, true, light, null);
    }

    public static void drawStringWithFont(GraphicsHolder graphicsHolder, String text, IGui.HorizontalAlignment horizontalAlignment, IGui.VerticalAlignment verticalAlignment, float x, float y, float maxWidth, float maxHeight, float scale, int textColor, boolean shadow, int light, @Nullable DrawingCallback drawingCallback) {
        IDrawing.drawStringWithFont(graphicsHolder, text, horizontalAlignment, verticalAlignment, horizontalAlignment, x, y, maxWidth, maxHeight, scale, textColor, shadow, light, drawingCallback);
    }

    public static void drawStringWithFont(GraphicsHolder graphicsHolder, String text, IGui.HorizontalAlignment horizontalAlignment, IGui.VerticalAlignment verticalAlignment, IGui.HorizontalAlignment xAlignment, float x, float y, float maxWidth, float maxHeight, float scale, int textColor, boolean shadow, int light, @Nullable DrawingCallback drawingCallback) {
        IDrawing.drawStringWithFont(graphicsHolder, text, horizontalAlignment, verticalAlignment, xAlignment, x, y, maxWidth, maxHeight, scale, textColor, textColor, 2.0f, shadow, light, drawingCallback);
    }

    public static void drawStringWithFont(GraphicsHolder graphicsHolder, String text, IGui.HorizontalAlignment horizontalAlignment, IGui.VerticalAlignment verticalAlignment, IGui.HorizontalAlignment xAlignment, float x, float y, float maxWidth, float maxHeight, float scale, int textColorCjk, int textColor, float fontSizeRatio, boolean shadow, int light, @Nullable DrawingCallback drawingCallback) {
        float scaleX;
        float totalWidthScaled;
        boolean isCJK;
        Style style;
        Style style2 = style = Config.getClient().getUseMTRFont() ? Style.getEmptyMapped().withFont(new Identifier("mtr", "mtr")) : Style.getEmptyMapped();
        while (text.contains("||")) {
            text = text.replace("||", "|");
        }
        String[] stringSplit = text.split("\\|");
        BooleanArrayList isCJKList = new BooleanArrayList();
        ObjectArrayList<OrderedText> orderedTexts = new ObjectArrayList<OrderedText>();
        int totalHeight = 0;
        int totalWidth = 0;
        for (String stringSplitPart : stringSplit) {
            isCJK = IGui.isCjk(stringSplitPart);
            isCJKList.add(isCJK);
            OrderedText orderedText = TextHelper.mutableTextToOrderedText(TextHelper.setStyle(TextHelper.literal(stringSplitPart), style));
            orderedTexts.add(orderedText);
            totalHeight += Math.round(10.0f * (isCJK ? fontSizeRatio : 1.0f));
            int width = (int)Math.ceil((float)GraphicsHolder.getTextWidth(orderedText) * (isCJK ? fontSizeRatio : 1.0f));
            if (width <= totalWidth) continue;
            totalWidth = width;
        }
        if (maxHeight >= 0.0f && (float)totalHeight / scale > maxHeight) {
            scale = (float)totalHeight / maxHeight;
        }
        graphicsHolder.push();
        if (maxWidth >= 0.0f && (float)totalWidth > maxWidth * scale) {
            totalWidthScaled = maxWidth * scale;
            scaleX = (float)totalWidth / maxWidth;
        } else {
            totalWidthScaled = totalWidth;
            scaleX = scale;
        }
        graphicsHolder.scale(1.0f / scaleX, 1.0f / scale, 1.0f / scale);
        float offset = verticalAlignment.getOffset(y * scale, totalHeight);
        for (int i = 0; i < orderedTexts.size(); ++i) {
            float extraScale;
            isCJK = isCJKList.getBoolean(i);
            float f = extraScale = isCJK ? fontSizeRatio : 1.0f;
            if (isCJK) {
                graphicsHolder.push();
                graphicsHolder.scale(extraScale, extraScale, 1.0f);
            }
            float xOffset = horizontalAlignment.getOffset(xAlignment.getOffset(x * scaleX, totalWidth), (float)GraphicsHolder.getTextWidth((OrderedText)orderedTexts.get(i)) * extraScale - (float)totalWidth);
            float shade = light == GraphicsHolder.getDefaultLight() ? 1.0f : Math.min((float)LightmapTextureManager.getBlockLightCoordinates(light) / 16.0f * 0.1f + 0.7f, 1.0f);
            int a = (isCJK ? textColorCjk : textColor) >> 24 & 0xFF;
            int r = (int)((float)((isCJK ? textColorCjk : textColor) >> 16 & 0xFF) * shade);
            int g = (int)((float)((isCJK ? textColorCjk : textColor) >> 8 & 0xFF) * shade);
            int b = (int)((float)((isCJK ? textColorCjk : textColor) & 0xFF) * shade);
            graphicsHolder.drawText((OrderedText)orderedTexts.get(i), Math.round(xOffset / extraScale), Math.round(offset / extraScale), (a << 24) + (r << 16) + (g << 8) + b, shadow, light);
            if (isCJK) {
                graphicsHolder.pop();
            }
            offset += 10.0f * extraScale;
        }
        graphicsHolder.pop();
        if (drawingCallback != null) {
            float x1 = xAlignment.getOffset(x, totalWidthScaled / scale);
            float y1 = verticalAlignment.getOffset(y, (float)totalHeight / scale);
            drawingCallback.drawingCallback(x1, y1, x1 + totalWidthScaled / scale, y1 + (float)totalHeight / scale);
        }
    }

    public static void drawTexture(GraphicsHolder graphicsHolder, float x1, float y1, float z1, float x2, float y2, float z2, Direction facing, int color, int light) {
        IDrawing.drawTexture(graphicsHolder, x1, y1, z1, x2, y2, z2, 0.0f, 0.0f, 1.0f, 1.0f, facing, color, light);
    }

    public static void drawTexture(GraphicsHolder graphicsHolder, float x, float y, float width, float height, Direction facing, int light) {
        IDrawing.drawTexture(graphicsHolder, x, y, 0.0f, x + width, y + height, 0.0f, 0.0f, 0.0f, 1.0f, 1.0f, facing, -1, light);
    }

    public static void drawTexture(GraphicsHolder graphicsHolder, float x, float y, float width, float height, float u1, float v1, float u2, float v2, Direction facing, int color, int light) {
        IDrawing.drawTexture(graphicsHolder, x, y, 0.0f, x + width, y + height, 0.0f, u1, v1, u2, v2, facing, color, light);
    }

    public static void drawTexture(GraphicsHolder graphicsHolder, float x1, float y1, float z1, float x2, float y2, float z2, float u1, float v1, float u2, float v2, Direction facing, int color, int light) {
        IDrawing.drawTexture(graphicsHolder, x1, y2, z1, x2, y2, z2, x2, y1, z2, x1, y1, z1, u1, v1, u2, v2, facing, color, light);
    }

    public static void drawTexture(GraphicsHolder graphicsHolder, double x1, double y1, double z1, double x2, double y2, double z2, double x3, double y3, double z3, double x4, double y4, double z4, Vector3d playerOffset, float u1, float v1, float u2, float v2, Direction facing, int color, int light) {
        IDrawing.drawTexture(graphicsHolder, (float)(x1 - playerOffset.getXMapped()), (float)(y1 - playerOffset.getYMapped()), (float)(z1 - playerOffset.getZMapped()), (float)(x2 - playerOffset.getXMapped()), (float)(y2 - playerOffset.getYMapped()), (float)(z2 - playerOffset.getZMapped()), (float)(x3 - playerOffset.getXMapped()), (float)(y3 - playerOffset.getYMapped()), (float)(z3 - playerOffset.getZMapped()), (float)(x4 - playerOffset.getXMapped()), (float)(y4 - playerOffset.getYMapped()), (float)(z4 - playerOffset.getZMapped()), u1, v1, u2, v2, facing, color, light);
    }

    public static void drawTexture(GraphicsHolder graphicsHolder, float x1, float y1, float z1, float x2, float y2, float z2, float x3, float y3, float z3, float x4, float y4, float z4, float u1, float v1, float u2, float v2, Direction facing, int color, int light) {
        graphicsHolder.drawTextureInWorld(x1, y1, z1, x2, y2, z2, x3, y3, z3, x4, y4, z4, u1, v1, u2, v2, facing, color, light);
    }

    public static void drawSevenSegment(GraphicsHolder graphicsHolder, String numberString, float availableSpace, float x, float y, float height, IGui.HorizontalAlignment horizontalAlignment, int color, int light) {
        try {
            IDrawing.drawSevenSegment(graphicsHolder, Integer.parseInt(numberString), availableSpace, x, y, height, horizontalAlignment, color, light);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void drawSevenSegment(GraphicsHolder graphicsHolder, int number, float availableSpace, float x, float y, float height, IGui.HorizontalAlignment horizontalAlignment, int color, int light) {
        float u = 0.25f;
        float v = 0.33203125f;
        float paddingMultiplier = 1.2f;
        float digitWidth = height * 0.25f / 0.33203125f * 1.2f;
        int digits = (int)Math.floor(availableSpace / digitWidth);
        float startX = horizontalAlignment.getOffset(x, (float)digits * digitWidth - availableSpace);
        for (int i = 0; i < digits; ++i) {
            int digit = number / (int)Math.pow(10.0, digits - i - 1) % 10;
            float digitX = startX + digitWidth * (float)i;
            float digitU = (float)(digit % 4) * 0.25f;
            float digitV = (float)Math.floorDiv(digit, 4) * 0.33203125f;
            IDrawing.drawTexture(graphicsHolder, digitX + 0.20000005f * digitWidth / 2.0f, y, digitWidth / 1.2f, height, digitU, digitV, digitU + 0.25f, digitV + 0.33203125f, Direction.UP, color, light);
        }
    }

    public static void setPositionAndWidth(ButtonWidgetExtension widget, int x, int y, int widgetWidth) {
        widget.setX2(x);
        widget.setY2(y);
        widget.setWidth2(MathHelper.clamp(widgetWidth, 0, 380));
    }

    public static void setPositionAndWidth(CheckboxWidgetExtension widget, int x, int y, int widgetWidth) {
        widget.setX2(x);
        widget.setY2(y);
        widget.setWidth2(MathHelper.clamp(widgetWidth, 0, 380));
    }

    public static void setPositionAndWidth(TextFieldWidgetExtension widget, int x, int y, int widgetWidth) {
        widget.setX2(x);
        widget.setY2(y);
        widget.setWidth2(MathHelper.clamp(widgetWidth, 0, 376));
    }

    public static void setPositionAndWidth(TexturedButtonWidgetExtension widget, int x, int y, int widgetWidth) {
        widget.setX2(x);
        widget.setY2(y);
        widget.setWidth2(MathHelper.clamp(widgetWidth, 0, 380));
    }

    public static void setPositionAndWidth(SliderWidgetExtension widget, int x, int y, int widgetWidth) {
        widget.setX2(x);
        widget.setY2(y);
        widget.setWidth2(MathHelper.clamp(widgetWidth, 0, 380));
    }

    public static void narrateOrAnnounce(String narrateMessage, ObjectArrayList<MutableText> chatMessages) {
        ClientPlayerEntity player;
        if (Config.getClient().getTextToSpeechAnnouncements() && !narrateMessage.isEmpty()) {
            Narrator.getNarrator().say(narrateMessage, true);
        }
        if (Config.getClient().getChatAnnouncements() && !chatMessages.isEmpty() && (player = MinecraftClient.getInstance().getPlayerMapped()) != null) {
            chatMessages.forEach(chatMessage -> {
                if (!chatMessage.getString().isEmpty()) {
                    player.sendMessage(new Text((class_2561)chatMessage.data), false);
                }
            });
        }
    }

    public static MutableText withMTRFont(MutableText text) {
        return Config.getClient().getUseMTRFont() ? TextHelper.setStyle(text, Style.getEmptyMapped().withFont(new Identifier("mtr", "mtr"))) : text;
    }

    @FunctionalInterface
    public static interface DrawingCallback {
        public void drawingCallback(float var1, float var2, float var3, float var4);
    }
}

