/*
 * Decompiled with CFR 0.152.
 */
package org.mtr.mod.client;

import org.mtr.core.tool.Utilities;
import org.mtr.mapping.holder.Box;
import org.mtr.mapping.holder.Vector3d;
import org.mtr.mod.render.PositionAndRotation;

public class GangwayMovementPositions {
    private double xMin;
    private double xMax;
    private double xMinClamped;
    private double xMaxClamped;
    private double y;
    private double z;
    private final PositionAndRotation positionAndRotation;
    private final boolean getMax;

    public GangwayMovementPositions(PositionAndRotation positionAndRotation, boolean getMax) {
        this.positionAndRotation = positionAndRotation;
        this.getMax = getMax;
    }

    public void check(Box box) {
        if (this.getMax) {
            if (box.getMaxZMapped() > this.z) {
                this.xMin = box.getMinXMapped();
                this.xMinClamped = this.xMin + (double)0.3f;
                this.xMax = box.getMaxXMapped();
                this.xMaxClamped = this.xMax - (double)0.3f;
                this.y = box.getMaxYMapped();
                this.z = box.getMaxZMapped();
            }
        } else if (box.getMinZMapped() < this.z) {
            this.xMin = box.getMinXMapped();
            this.xMinClamped = this.xMin + (double)0.3f;
            this.xMax = box.getMaxXMapped();
            this.xMaxClamped = this.xMax - (double)0.3f;
            this.y = box.getMaxYMapped();
            this.z = box.getMinZMapped();
        }
    }

    public Box getBox() {
        return new Box(this.xMin, this.y, this.z, this.xMax, this.y, this.z + (double)((float)(this.getMax ? 1 : -1) * 0.3f));
    }

    public double getPercentageX(double x) {
        return (Utilities.clamp(x, this.xMinClamped, this.xMaxClamped) - this.xMinClamped) / (this.xMaxClamped - this.xMinClamped);
    }

    public double getPercentageZ(double z) {
        if (this.getMax) {
            return Utilities.clamp(z - this.z, 0.0, 1.0);
        }
        return Utilities.clamp(z - this.z, -1.0, 0.0) + 1.0;
    }

    public double getX(double percentageX) {
        return (this.xMaxClamped - this.xMinClamped) * percentageX + this.xMinClamped;
    }

    public double getZ() {
        return this.z;
    }

    public Vector3d getMinWorldPosition() {
        return this.positionAndRotation.transformForwards(new Vector3d(this.xMinClamped, this.y, this.z), Vector3d::rotateX, Vector3d::rotateY, Vector3d::add);
    }

    public Vector3d getMaxWorldPosition() {
        return this.positionAndRotation.transformForwards(new Vector3d(this.xMaxClamped, this.y, this.z), Vector3d::rotateX, Vector3d::rotateY, Vector3d::add);
    }
}

