/*
 * Decompiled with CFR 0.152.
 */
package org.mtr.mapping.registry;

import java.util.Random;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientChunkEvents;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayConnectionEvents;
import net.fabricmc.fabric.api.client.rendering.v1.HudRenderCallback;
import net.fabricmc.fabric.api.resource.IdentifiableResourceReloadListener;
import net.fabricmc.fabric.api.resource.ResourceManagerHelper;
import net.fabricmc.fabric.api.resource.SimpleSynchronousResourceReloadListener;
import net.minecraft.class_2960;
import net.minecraft.class_3264;
import net.minecraft.class_3300;
import org.mtr.mapping.annotation.MappedMethod;
import org.mtr.mapping.holder.ClientWorld;
import org.mtr.mapping.holder.WorldChunk;
import org.mtr.mapping.mapper.GraphicsHolder;
import org.mtr.mapping.tool.DummyClass;

public class EventRegistryClient
extends DummyClass {
    @MappedMethod
    public void registerStartClientTick(Runnable runnable2) {
        ClientTickEvents.START_CLIENT_TICK.register(minecraftServer -> runnable2.run());
    }

    @MappedMethod
    public void registerEndClientTick(Runnable runnable2) {
        ClientTickEvents.END_CLIENT_TICK.register(minecraftServer -> runnable2.run());
    }

    @MappedMethod
    public void registerStartWorldTick(Consumer<ClientWorld> consumer) {
        ClientTickEvents.START_WORLD_TICK.register(clientWorld -> consumer.accept(new ClientWorld(clientWorld)));
    }

    @MappedMethod
    public void registerEndWorldTick(Consumer<ClientWorld> consumer) {
        ClientTickEvents.END_WORLD_TICK.register(clientWorld -> consumer.accept(new ClientWorld(clientWorld)));
    }

    @MappedMethod
    public void registerClientJoin(Runnable runnable2) {
        ClientPlayConnectionEvents.JOIN.register((handler, sender, client) -> runnable2.run());
    }

    @MappedMethod
    public void registerClientDisconnect(Runnable runnable2) {
        ClientPlayConnectionEvents.DISCONNECT.register((handler, client) -> runnable2.run());
    }

    @MappedMethod
    public void registerChunkLoad(BiConsumer<ClientWorld, WorldChunk> consumer) {
        ClientChunkEvents.CHUNK_LOAD.register((clientWorld, worldChunk) -> consumer.accept(new ClientWorld(clientWorld), new WorldChunk(worldChunk)));
    }

    @MappedMethod
    public void registerChunkUnload(BiConsumer<ClientWorld, WorldChunk> consumer) {
        ClientChunkEvents.CHUNK_UNLOAD.register((clientWorld, worldChunk) -> consumer.accept(new ClientWorld(clientWorld), new WorldChunk(worldChunk)));
    }

    @MappedMethod
    public void registerGuiRendering(Consumer<GraphicsHolder> consumer) {
        HudRenderCallback.EVENT.register((drawContext, tickDelta) -> GraphicsHolder.createInstanceSafe(drawContext, consumer));
    }

    @MappedMethod
    public void registerResourceReloadEvent(final Runnable runnable2) {
        final class_2960 identifier = new class_2960(Integer.toHexString(new Random().nextInt()), "resource");
        ResourceManagerHelper.get((class_3264)class_3264.field_14188).registerReloadListener((IdentifiableResourceReloadListener)new SimpleSynchronousResourceReloadListener(){

            @Deprecated
            public final class_2960 getFabricId() {
                return identifier;
            }

            @Deprecated
            public final void method_14491(class_3300 manager) {
                runnable2.run();
            }
        });
    }
}

