/*
 * Decompiled with CFR 0.152.
 */
package org.mtr.libraries.okhttp3.internal;

import java.nio.charset.Charset;
import javax.net.ssl.SSLSocket;
import org.mtr.libraries.kotlin.Metadata;
import org.mtr.libraries.kotlin.Pair;
import org.mtr.libraries.kotlin.TuplesKt;
import org.mtr.libraries.kotlin.jvm.JvmName;
import org.mtr.libraries.kotlin.jvm.internal.Intrinsics;
import org.mtr.libraries.kotlin.text.Charsets;
import org.mtr.libraries.okhttp3.Cache;
import org.mtr.libraries.okhttp3.CipherSuite;
import org.mtr.libraries.okhttp3.ConnectionListener;
import org.mtr.libraries.okhttp3.ConnectionPool;
import org.mtr.libraries.okhttp3.ConnectionSpec;
import org.mtr.libraries.okhttp3.Cookie;
import org.mtr.libraries.okhttp3.Headers;
import org.mtr.libraries.okhttp3.HttpUrl;
import org.mtr.libraries.okhttp3.MediaType;
import org.mtr.libraries.okhttp3.OkHttpClient;
import org.mtr.libraries.okhttp3.Request;
import org.mtr.libraries.okhttp3.Response;
import org.mtr.libraries.okhttp3.internal._UtilCommonKt;
import org.mtr.libraries.okhttp3.internal.concurrent.TaskRunner;
import org.mtr.libraries.okhttp3.internal.connection.Exchange;
import org.mtr.libraries.okhttp3.internal.connection.RealConnection;
import org.mtr.libraries.org.jetbrains.annotations.NotNull;
import org.mtr.libraries.org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000\u008c\u0001\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u001a\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\tH\u0000\u001a \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\tH\u0000\u001a \u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0000\u001a\u0018\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0000\u001a\u001a\u0010\u001a\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0000\u001a\u0018\u0010\u001f\u001a\u00020\t2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020\u0013H\u0000\u001a\"\u0010#\u001a\u0004\u0018\u00010!2\u0006\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020\tH\u0000\u001a\u000e\u0010)\u001a\u00020**\u0004\u0018\u00010+H\u0000\u001a\u001c\u0010,\u001a\u0010\u0012\u0004\u0012\u00020*\u0012\u0006\u0012\u0004\u0018\u00010+0-*\u0004\u0018\u00010+H\u0000\u001a%\u0010.\u001a\b\u0012\u0004\u0012\u00020\t0/*\u00020\u000f2\f\u00100\u001a\b\u0012\u0004\u0012\u00020\t0/H\u0000\u00a2\u0006\u0002\u00101\u001a\u0014\u00102\u001a\u000203*\u0002032\u0006\u0010\u0018\u001a\u00020\u0019H\u0000\"\u0018\u0010\u0000\u001a\u00020\u0001*\u00020\u00028@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0004\u00a8\u00064"}, d2={"connection", "Lorg/mtr/libraries/okhttp3/internal/connection/RealConnection;", "Lorg/mtr/libraries/okhttp3/Response;", "getConnection", "(Lokhttp3/Response;)Lokhttp3/internal/connection/RealConnection;", "addHeaderLenient", "Lorg/mtr/libraries/okhttp3/Headers$Builder;", "builder", "line", "", "name", "value", "applyConnectionSpec", "", "connectionSpec", "Lorg/mtr/libraries/okhttp3/ConnectionSpec;", "sslSocket", "Ljavax/net/ssl/SSLSocket;", "isFallback", "", "buildConnectionPool", "Lorg/mtr/libraries/okhttp3/ConnectionPool;", "connectionListener", "Lorg/mtr/libraries/okhttp3/ConnectionListener;", "taskRunner", "Lorg/mtr/libraries/okhttp3/internal/concurrent/TaskRunner;", "cacheGet", "cache", "Lorg/mtr/libraries/okhttp3/Cache;", "request", "Lorg/mtr/libraries/okhttp3/Request;", "cookieToString", "cookie", "Lorg/mtr/libraries/okhttp3/Cookie;", "forObsoleteRfc2965", "parseCookie", "currentTimeMillis", "", "url", "Lorg/mtr/libraries/okhttp3/HttpUrl;", "setCookie", "charsetOrUtf8", "Ljava/nio/charset/Charset;", "Lorg/mtr/libraries/okhttp3/MediaType;", "chooseCharset", "Lorg/mtr/libraries/kotlin/Pair;", "effectiveCipherSuites", "", "socketEnabledCipherSuites", "(Lokhttp3/ConnectionSpec;[Ljava/lang/String;)[Ljava/lang/String;", "taskRunnerInternal", "Lorg/mtr/libraries/okhttp3/OkHttpClient$Builder;", "okhttp"})
@JvmName(name="Internal")
public final class Internal {
    @Nullable
    public static final Cookie parseCookie(long currentTimeMillis, @NotNull HttpUrl url, @NotNull String setCookie) {
        Intrinsics.checkNotNullParameter(url, "url");
        Intrinsics.checkNotNullParameter(setCookie, "setCookie");
        return Cookie.Companion.parse$okhttp(currentTimeMillis, url, setCookie);
    }

    @NotNull
    public static final String cookieToString(@NotNull Cookie cookie, boolean forObsoleteRfc2965) {
        Intrinsics.checkNotNullParameter(cookie, "cookie");
        return cookie.toString$okhttp(forObsoleteRfc2965);
    }

    @NotNull
    public static final Headers.Builder addHeaderLenient(@NotNull Headers.Builder builder, @NotNull String line) {
        Intrinsics.checkNotNullParameter(builder, "builder");
        Intrinsics.checkNotNullParameter(line, "line");
        return builder.addLenient$okhttp(line);
    }

    @NotNull
    public static final Headers.Builder addHeaderLenient(@NotNull Headers.Builder builder, @NotNull String name, @NotNull String value) {
        Intrinsics.checkNotNullParameter(builder, "builder");
        Intrinsics.checkNotNullParameter(name, "name");
        Intrinsics.checkNotNullParameter(value, "value");
        return builder.addLenient$okhttp(name, value);
    }

    @Nullable
    public static final Response cacheGet(@NotNull Cache cache, @NotNull Request request) {
        Intrinsics.checkNotNullParameter(cache, "cache");
        Intrinsics.checkNotNullParameter(request, "request");
        return cache.get$okhttp(request);
    }

    public static final void applyConnectionSpec(@NotNull ConnectionSpec connectionSpec, @NotNull SSLSocket sslSocket, boolean isFallback) {
        Intrinsics.checkNotNullParameter(connectionSpec, "connectionSpec");
        Intrinsics.checkNotNullParameter(sslSocket, "sslSocket");
        connectionSpec.apply$okhttp(sslSocket, isFallback);
    }

    @NotNull
    public static final String[] effectiveCipherSuites(@NotNull ConnectionSpec $this$effectiveCipherSuites, @NotNull String[] socketEnabledCipherSuites) {
        Intrinsics.checkNotNullParameter($this$effectiveCipherSuites, "<this>");
        Intrinsics.checkNotNullParameter(socketEnabledCipherSuites, "socketEnabledCipherSuites");
        return $this$effectiveCipherSuites.getCipherSuitesAsString$okhttp() != null ? _UtilCommonKt.intersect($this$effectiveCipherSuites.getCipherSuitesAsString$okhttp(), socketEnabledCipherSuites, CipherSuite.Companion.getORDER_BY_NAME$okhttp()) : socketEnabledCipherSuites;
    }

    @NotNull
    public static final Pair<Charset, MediaType> chooseCharset(@Nullable MediaType $this$chooseCharset) {
        Charset charset = Charsets.UTF_8;
        MediaType finalContentType = $this$chooseCharset;
        if ($this$chooseCharset != null) {
            Charset resolvedCharset = MediaType.charset$default($this$chooseCharset, null, 1, null);
            if (resolvedCharset == null) {
                charset = Charsets.UTF_8;
                finalContentType = MediaType.Companion.parse($this$chooseCharset + "; charset=utf-8");
            } else {
                charset = resolvedCharset;
            }
        }
        return TuplesKt.to(charset, finalContentType);
    }

    @NotNull
    public static final Charset charsetOrUtf8(@Nullable MediaType $this$charsetOrUtf8) {
        Object object = $this$charsetOrUtf8;
        if (object == null || (object = MediaType.charset$default((MediaType)object, null, 1, null)) == null) {
            object = Charsets.UTF_8;
        }
        return object;
    }

    @NotNull
    public static final RealConnection getConnection(@NotNull Response $this$connection) {
        Intrinsics.checkNotNullParameter($this$connection, "<this>");
        Exchange exchange = $this$connection.exchange();
        Intrinsics.checkNotNull(exchange);
        return exchange.getConnection$okhttp();
    }

    @NotNull
    public static final OkHttpClient.Builder taskRunnerInternal(@NotNull OkHttpClient.Builder $this$taskRunnerInternal, @NotNull TaskRunner taskRunner) {
        Intrinsics.checkNotNullParameter($this$taskRunnerInternal, "<this>");
        Intrinsics.checkNotNullParameter(taskRunner, "taskRunner");
        return $this$taskRunnerInternal.taskRunner$okhttp(taskRunner);
    }

    @NotNull
    public static final ConnectionPool buildConnectionPool(@NotNull ConnectionListener connectionListener, @NotNull TaskRunner taskRunner) {
        Intrinsics.checkNotNullParameter(connectionListener, "connectionListener");
        Intrinsics.checkNotNullParameter(taskRunner, "taskRunner");
        return new ConnectionPool(0, 0L, null, taskRunner, connectionListener, 0, 0, 0, 0, 0, false, false, null, 8167, null);
    }
}

