/*
 * Decompiled with CFR 0.152.
 */
package org.mtr.core.generated.data;

import javax.annotation.Nonnull;
import org.mtr.core.data.Data;
import org.mtr.core.data.LiftFloor;
import org.mtr.core.data.LiftInstruction;
import org.mtr.core.data.NameColorDataBase;
import org.mtr.core.data.TransportMode;
import org.mtr.core.data.VehicleRidingEntity;
import org.mtr.core.serializer.ReaderBase;
import org.mtr.core.serializer.WriterBase;
import org.mtr.core.tool.Angle;
import org.mtr.core.tool.EnumHelper;
import org.mtr.libraries.it.unimi.dsi.fastutil.objects.ObjectArrayList;

public abstract class LiftSchema
extends NameColorDataBase {
    protected double height;
    protected double width;
    protected double depth;
    protected double offsetX;
    protected double offsetY;
    protected double offsetZ;
    protected boolean isDoubleSided;
    protected String style = "";
    protected Angle angle = Angle.values()[0];
    protected double railProgress;
    protected double speed;
    protected long stoppingCoolDown;
    protected final ObjectArrayList<LiftFloor> floors = new ObjectArrayList();
    protected final ObjectArrayList<LiftInstruction> instructions = new ObjectArrayList();
    protected final ObjectArrayList<VehicleRidingEntity> ridingEntities = new ObjectArrayList();

    protected LiftSchema(TransportMode transportMode, Data data) {
        super(transportMode, data);
    }

    protected LiftSchema(ReaderBase readerBase, Data data) {
        super(readerBase, data);
    }

    @Override
    public void updateData(ReaderBase readerBase) {
        super.updateData(readerBase);
        readerBase.unpackDouble("height", value -> {
            this.height = value;
        });
        readerBase.unpackDouble("width", value -> {
            this.width = value;
        });
        readerBase.unpackDouble("depth", value -> {
            this.depth = value;
        });
        readerBase.unpackDouble("offsetX", value -> {
            this.offsetX = value;
        });
        readerBase.unpackDouble("offsetY", value -> {
            this.offsetY = value;
        });
        readerBase.unpackDouble("offsetZ", value -> {
            this.offsetZ = value;
        });
        readerBase.unpackBoolean("isDoubleSided", value -> {
            this.isDoubleSided = value;
        });
        readerBase.unpackString("style", value -> {
            this.style = value;
        });
        readerBase.unpackString("angle", value -> {
            this.angle = EnumHelper.valueOf(Angle.values()[0], value);
        });
        readerBase.unpackDouble("railProgress", value -> {
            this.railProgress = value;
        });
        readerBase.unpackDouble("speed", value -> {
            this.speed = value;
        });
        readerBase.unpackLong("stoppingCoolDown", value -> {
            this.stoppingCoolDown = value;
        });
        readerBase.iterateReaderArray("floors", this.floors::clear, readerBaseChild -> this.floors.add(new LiftFloor((ReaderBase)readerBaseChild)));
        readerBase.iterateReaderArray("instructions", this.instructions::clear, readerBaseChild -> this.instructions.add(new LiftInstruction((ReaderBase)readerBaseChild)));
        readerBase.iterateReaderArray("ridingEntities", this.ridingEntities::clear, readerBaseChild -> this.ridingEntities.add(new VehicleRidingEntity((ReaderBase)readerBaseChild)));
    }

    @Override
    public void serializeData(WriterBase writerBase) {
        super.serializeData(writerBase);
        this.serializeHeight(writerBase);
        this.serializeWidth(writerBase);
        this.serializeDepth(writerBase);
        this.serializeOffsetX(writerBase);
        this.serializeOffsetY(writerBase);
        this.serializeOffsetZ(writerBase);
        this.serializeIsDoubleSided(writerBase);
        this.serializeStyle(writerBase);
        this.serializeAngle(writerBase);
        this.serializeRailProgress(writerBase);
        this.serializeSpeed(writerBase);
        this.serializeStoppingCoolDown(writerBase);
        this.serializeFloors(writerBase);
        this.serializeInstructions(writerBase);
        this.serializeRidingEntities(writerBase);
    }

    @Override
    @Nonnull
    public String toString() {
        return super.toString() + "height: " + this.height + "\nwidth: " + this.width + "\ndepth: " + this.depth + "\noffsetX: " + this.offsetX + "\noffsetY: " + this.offsetY + "\noffsetZ: " + this.offsetZ + "\nisDoubleSided: " + this.isDoubleSided + "\nstyle: " + this.style + "\nangle: " + (Object)((Object)this.angle) + "\nrailProgress: " + this.railProgress + "\nspeed: " + this.speed + "\nstoppingCoolDown: " + this.stoppingCoolDown + "\nfloors: " + this.floors + "\ninstructions: " + this.instructions + "\nridingEntities: " + this.ridingEntities + "\n";
    }

    protected void serializeHeight(WriterBase writerBase) {
        writerBase.writeDouble("height", this.height);
    }

    protected void serializeWidth(WriterBase writerBase) {
        writerBase.writeDouble("width", this.width);
    }

    protected void serializeDepth(WriterBase writerBase) {
        writerBase.writeDouble("depth", this.depth);
    }

    protected void serializeOffsetX(WriterBase writerBase) {
        writerBase.writeDouble("offsetX", this.offsetX);
    }

    protected void serializeOffsetY(WriterBase writerBase) {
        writerBase.writeDouble("offsetY", this.offsetY);
    }

    protected void serializeOffsetZ(WriterBase writerBase) {
        writerBase.writeDouble("offsetZ", this.offsetZ);
    }

    protected void serializeIsDoubleSided(WriterBase writerBase) {
        writerBase.writeBoolean("isDoubleSided", this.isDoubleSided);
    }

    protected void serializeStyle(WriterBase writerBase) {
        writerBase.writeString("style", this.style);
    }

    protected void serializeAngle(WriterBase writerBase) {
        writerBase.writeString("angle", this.angle.toString());
    }

    protected void serializeRailProgress(WriterBase writerBase) {
        writerBase.writeDouble("railProgress", this.railProgress);
    }

    protected void serializeSpeed(WriterBase writerBase) {
        writerBase.writeDouble("speed", this.speed);
    }

    protected void serializeStoppingCoolDown(WriterBase writerBase) {
        writerBase.writeLong("stoppingCoolDown", this.stoppingCoolDown);
    }

    protected void serializeFloors(WriterBase writerBase) {
        writerBase.writeDataset(this.floors, "floors");
    }

    protected void serializeInstructions(WriterBase writerBase) {
        writerBase.writeDataset(this.instructions, "instructions");
    }

    protected void serializeRidingEntities(WriterBase writerBase) {
        writerBase.writeDataset(this.ridingEntities, "ridingEntities");
    }
}

